/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.application.metadata.SpringBootValueProvider;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigValueProviderReference;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootAdditionalConfigPropertyNameReference
extends PsiReferenceBase<PsiElement> {
    private static final TailType CLOSE_PROPERTY_NAME_TAIL = new TailType(){

        public int processTail(Editor editor, int tailOffset) {
            tailOffset = 1.insertChar((Editor)editor, (int)tailOffset, (char)'\"');
            tailOffset = 1.insertChar((Editor)editor, (int)tailOffset, (char)':');
            return 1.insertChar((Editor)editor, (int)tailOffset, (char)' ', (boolean)false);
        }
    };
    private static final TailType STRING_LITERAL_TAIL = new TailType(){

        public int processTail(Editor editor, int tailOffset) {
            tailOffset = CLOSE_PROPERTY_NAME_TAIL.processTail(editor, tailOffset);
            tailOffset = 2.insertChar((Editor)editor, (int)tailOffset, (char)'\"');
            tailOffset = 2.insertChar((Editor)editor, (int)tailOffset, (char)'\"');
            return 2.moveCaret((Editor)editor, (int)tailOffset, (int)-1);
        }
    };
    private static final TailType ARRAY_TAIL = new TailType(){

        public int processTail(Editor editor, int tailOffset) {
            tailOffset = CLOSE_PROPERTY_NAME_TAIL.processTail(editor, tailOffset);
            tailOffset = 3.insertChar((Editor)editor, (int)tailOffset, (char)'[');
            tailOffset = 3.insertChar((Editor)editor, (int)tailOffset, (char)'{');
            tailOffset = 3.insertChar((Editor)editor, (int)tailOffset, (char)'}');
            tailOffset = 3.insertChar((Editor)editor, (int)tailOffset, (char)']');
            return 3.moveCaret((Editor)editor, (int)tailOffset, (int)-2);
        }
    };
    private static final TailType OBJECT_TAIL = new TailType(){

        public int processTail(Editor editor, int tailOffset) {
            tailOffset = CLOSE_PROPERTY_NAME_TAIL.processTail(editor, tailOffset);
            tailOffset = 4.insertChar((Editor)editor, (int)tailOffset, (char)'{');
            tailOffset = 4.insertChar((Editor)editor, (int)tailOffset, (char)'}');
            return 4.moveCaret((Editor)editor, (int)tailOffset, (int)-1);
        }
    };
    private static final Function<Variant, LookupElement> VARIANT_LOOKUP_ELEMENT_FUNCTION = variant -> {
        LookupElementBuilder builder = LookupElementBuilder.create((String)((Variant)variant).name);
        switch (((Variant)variant).variantType) {
            case STRING_LITERAL: {
                return TailTypeDecorator.withTail((LookupElement)builder, (TailType)STRING_LITERAL_TAIL);
            }
            case ARRAY: {
                return TailTypeDecorator.withTail((LookupElement)builder, (TailType)ARRAY_TAIL);
            }
            case OBJECT: {
                return TailTypeDecorator.withTail((LookupElement)builder, (TailType)OBJECT_TAIL);
            }
            case DEFAULT: {
                return TailTypeDecorator.withTail((LookupElement)builder, (TailType)CLOSE_PROPERTY_NAME_TAIL);
            }
        }
        throw new IllegalStateException(variant.toString());
    };
    private final GroupContext myGroupContext;

    SpringBootAdditionalConfigPropertyNameReference(PsiElement element, GroupContext groupContext) {
        super(element);
        this.myGroupContext = groupContext;
    }

    @Nullable
    public PsiElement resolve() {
        return this.getElement();
    }

    @NotNull
    public Object[] getVariants() {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        boolean isAtLeast13 = SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0);
        switch (this.myGroupContext) {
            case FAKE_TOP_LEVEL: {
                if (isAtLeast13) {
                    Object[] objectArray = this.createVariants(EnumSet.of(Variant.TOP_LEVEL_GROUPS, Variant.TOP_LEVEL_PROPERTIES, Variant.TOP_LEVEL_HINTS));
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigPropertyNameReference", "getVariants"));
                    }
                    return objectArray;
                }
                Object[] objectArray = this.createVariants(EnumSet.of(Variant.TOP_LEVEL_GROUPS, Variant.TOP_LEVEL_PROPERTIES));
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigPropertyNameReference", "getVariants"));
                }
                return objectArray;
            }
            case GROUPS: {
                Object[] objectArray = this.createVariants(EnumSet.of(Variant.TYPE, Variant.SOURCE_TYPE, Variant.NAME, Variant.DESCRIPTION, Variant.SOURCE_METHOD));
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigPropertyNameReference", "getVariants"));
                }
                return objectArray;
            }
            case PROPERTIES: {
                if (isAtLeast13) {
                    Object[] objectArray = this.createVariants(EnumSet.of(Variant.TYPE, new Variant[]{Variant.SOURCE_TYPE, Variant.NAME, Variant.DESCRIPTION, Variant.DEFAULT_VALUE, Variant.DEPRECATION}));
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigPropertyNameReference", "getVariants"));
                    }
                    return objectArray;
                }
                Object[] objectArray = this.createVariants(EnumSet.of(Variant.TYPE, new Variant[]{Variant.SOURCE_TYPE, Variant.NAME, Variant.DESCRIPTION, Variant.DEFAULT_VALUE, Variant.DEPRECATED}));
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigPropertyNameReference", "getVariants"));
                }
                return objectArray;
            }
            case DEPRECATION: {
                Object[] objectArray = this.createVariants(EnumSet.of(Variant.REASON, Variant.REPLACEMENT));
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigPropertyNameReference", "getVariants"));
                }
                return objectArray;
            }
            case HINTS: {
                Object[] objectArray = this.createVariants(EnumSet.of(Variant.NAME, Variant.VALUES, Variant.PROVIDERS));
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigPropertyNameReference", "getVariants"));
                }
                return objectArray;
            }
            case HINTS_VALUES: {
                Object[] objectArray = this.createVariants(EnumSet.of(Variant.VALUE, Variant.DESCRIPTION));
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigPropertyNameReference", "getVariants"));
                }
                return objectArray;
            }
            case HINTS_PROVIDERS: {
                Object[] objectArray = this.createVariants(EnumSet.of(Variant.NAME, Variant.PARAMETERS));
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigPropertyNameReference", "getVariants"));
                }
                return objectArray;
            }
            case HINTS_PARAMETERS: {
                SpringBootValueProvider valueProvider = this.findSpringBootValueProvider();
                if (valueProvider == null) {
                    if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigPropertyNameReference", "getVariants"));
                    }
                    return ArrayUtil.EMPTY_OBJECT_ARRAY;
                }
                EnumSet<Variant> myVariantsFromParameters = EnumSet.noneOf(Variant.class);
                for (SpringBootValueProvider.Parameter parameter : valueProvider.getParameters()) {
                    Variant variant = Variant.findByName(parameter.getName());
                    if (variant == null) continue;
                    myVariantsFromParameters.add(variant);
                }
                Object[] objectArray = this.createVariants(myVariantsFromParameters);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigPropertyNameReference", "getVariants"));
                }
                return objectArray;
            }
        }
        throw new IllegalStateException(this.myGroupContext.name());
    }

    @Nullable
    private SpringBootValueProvider findSpringBootValueProvider() {
        JsonObject parametersObject = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), JsonObject.class);
        if (parametersObject == null) {
            return null;
        }
        JsonObject superParent = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)parametersObject, JsonObject.class);
        if (superParent == null) {
            return null;
        }
        JsonProperty nameProperty = superParent.findProperty("name");
        if (nameProperty == null) {
            return null;
        }
        JsonStringLiteral nameLiteral = (JsonStringLiteral)ObjectUtils.tryCast((Object)nameProperty.getValue(), JsonStringLiteral.class);
        if (nameLiteral == null) {
            return null;
        }
        for (PsiReference reference : nameLiteral.getReferences()) {
            if (!(reference instanceof SpringBootAdditionalConfigValueProviderReference)) continue;
            return ((SpringBootAdditionalConfigValueProviderReference)reference).getValueProvider();
        }
        return null;
    }

    private LookupElement[] createVariants(EnumSet<Variant> variants) {
        JsonObject jsonObject = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), JsonObject.class);
        if (jsonObject == null) {
            return LookupElement.EMPTY_ARRAY;
        }
        Set existingProperties = ContainerUtil.map2Set((Collection)jsonObject.getPropertyList(), JsonProperty::getName);
        EnumSet<Variant> filteredVariants = EnumSet.noneOf(Variant.class);
        for (Variant variant : variants) {
            if (existingProperties.contains(variant.name)) continue;
            filteredVariants.add(variant);
        }
        return (LookupElement[])ContainerUtil.map2Array(filteredVariants, LookupElement.class, VARIANT_LOOKUP_ELEMENT_FUNCTION);
    }

    static enum GroupContext {
        FAKE_TOP_LEVEL("topLevel", SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0),
        GROUPS("groups", SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0),
        PROPERTIES("properties", SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0),
        DEPRECATION("deprecation", SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0),
        HINTS("hints", SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0),
        HINTS_VALUES("values", SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0),
        HINTS_PROVIDERS("providers", SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0),
        HINTS_PARAMETERS("parameters", SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0);

        private final String myPropertyName;
        private final SpringBootLibraryUtil.SpringBootVersion myMinimumVersion;

        private GroupContext(String propertyName, SpringBootLibraryUtil.SpringBootVersion minimumVersion) {
            this.myPropertyName = propertyName;
            this.myMinimumVersion = minimumVersion;
        }

        SpringBootLibraryUtil.SpringBootVersion getMinimumVersion() {
            return this.myMinimumVersion;
        }

        @Nullable
        static GroupContext forProperty(String propertyName) {
            for (GroupContext groupContext : GroupContext.values()) {
                if (!groupContext.myPropertyName.equals(propertyName)) continue;
                return groupContext;
            }
            return null;
        }
    }

    private static enum VariantType {
        DEFAULT,
        STRING_LITERAL,
        ARRAY,
        OBJECT;

    }

    private static enum Variant {
        TOP_LEVEL_GROUPS("groups", VariantType.ARRAY),
        TOP_LEVEL_PROPERTIES("properties", VariantType.ARRAY),
        TOP_LEVEL_HINTS("hints", VariantType.ARRAY),
        NAME("name", VariantType.STRING_LITERAL),
        TYPE("type", VariantType.STRING_LITERAL),
        SOURCE_TYPE("sourceType", VariantType.STRING_LITERAL),
        SOURCE_METHOD("sourceMethod", VariantType.STRING_LITERAL),
        DESCRIPTION("description", VariantType.STRING_LITERAL),
        DEFAULT_VALUE("defaultValue", VariantType.DEFAULT),
        DEPRECATED("deprecated", VariantType.DEFAULT),
        DEPRECATION("deprecation", VariantType.OBJECT),
        REASON("reason", VariantType.STRING_LITERAL),
        REPLACEMENT("replacement", VariantType.STRING_LITERAL),
        VALUES("values", VariantType.ARRAY),
        PROVIDERS("providers", VariantType.ARRAY),
        VALUE("value", VariantType.DEFAULT),
        PARAMETERS("parameters", VariantType.OBJECT),
        TARGET("target", VariantType.STRING_LITERAL),
        CONCRETE("concrete", VariantType.DEFAULT);

        private final String name;
        private final VariantType variantType;

        private Variant(String name, VariantType variantType) {
            this.name = name;
            this.variantType = variantType;
        }

        @Nullable
        static Variant findByName(String name) {
            for (Variant variant : Variant.values()) {
                if (!variant.name.equals(name)) continue;
                return variant;
            }
            return null;
        }
    }
}

