/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.keyPath.ConfigKeyPathReferenceSet;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesPlaceholderReference;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationPropertiesAnnotator
implements Annotator {
    private static final boolean DEBUG_MODE = ApplicationManager.getApplication().isUnitTestMode();

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesAnnotator", "annotate"));
        }
        if (!(element instanceof PropertyValueImpl) && !(element instanceof PropertyKeyImpl)) {
            return;
        }
        PsiFile file = holder.getCurrentAnnotationSession().getFile();
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        if (!SpringCommonUtils.hasSpringFacets((Project)file.getProject()) || !SpringBootApplicationPropertiesUtil.isApplicationPropertiesFile((PropertiesFile)file)) {
            return;
        }
        if (element instanceof PropertyValueImpl) {
            SpringBootApplicationPropertiesAnnotator.annotateValue(element, holder);
        }
        if (element instanceof PropertyKeyImpl) {
            SpringBootApplicationPropertiesAnnotator.annotateKey((PropertyKeyImpl)element, holder);
        }
    }

    private static void annotateValue(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesAnnotator", "annotateValue"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesAnnotator", "annotateValue"));
        }
        for (PsiReference reference : element.getReferences()) {
            if (!(reference instanceof SpringBootApplicationPropertiesPlaceholderReference)) continue;
            int elementOffset = element.getNode().getStartOffset();
            SpringBootApplicationPropertiesAnnotator.doAnnotate(holder, reference.getRangeInElement().shiftRight(elementOffset), PropertiesHighlighter.PROPERTY_KEY);
        }
    }

    private static void annotateKey(PropertyKeyImpl element, AnnotationHolder holder) {
        SpringBootApplicationMetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)element);
        if (configKey == null) {
            return;
        }
        String keyText = element.getText();
        int elementStartOffset = element.getNode().getStartOffset();
        SpringBootApplicationPropertiesAnnotator.annotateIndexAccessExpressions(holder, keyText, configKey, elementStartOffset);
        if (configKey.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.NORMAL})) {
            return;
        }
        block5: for (PsiReference psiReference : element.getReferences()) {
            if (!(psiReference instanceof ConfigKeyPathReferenceSet.Reference)) continue;
            ConfigKeyPathReferenceSet.Reference reference = (ConfigKeyPathReferenceSet.Reference)psiReference;
            TextRange referenceRange = reference.getRangeInElement().shiftRight(elementStartOffset);
            switch (reference.getPathType()) {
                case ENUM: {
                    SpringBootApplicationPropertiesAnnotator.doAnnotate(holder, referenceRange, DefaultLanguageHighlighterColors.CONSTANT);
                    continue block5;
                }
                case BEAN_PROPERTY: {
                    SpringBootApplicationPropertiesAnnotator.doAnnotate(holder, referenceRange, DefaultLanguageHighlighterColors.INSTANCE_METHOD);
                    continue block5;
                }
                case ARBITRARY_ENTRY_KEY: {
                    SpringBootApplicationPropertiesAnnotator.doAnnotateEnforced(holder, referenceRange, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES, "REGULAR_ITALIC_ATTRIBUTES");
                }
            }
        }
        if (configKey.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.MAP}) && configKey.getKeyItemHint() != SpringBootApplicationMetaConfigKey.ItemHint.NONE) {
            int configKeyNameLength = -1;
            for (PsiReference psiReference : element.getReferences()) {
                if (!(psiReference instanceof MetaConfigKeyReference)) continue;
                configKeyNameLength = psiReference.getRangeInElement().getEndOffset();
                break;
            }
            assert (configKeyNameLength != -1) : keyText;
            int endOffset = keyText.length() - configKeyNameLength - (StringUtil.endsWithChar((CharSequence)keyText, (char)']') ? 2 : 1);
            if (endOffset < 0) {
                return;
            }
            TextRange genericKeyRange = TextRange.from((int)(configKeyNameLength + 1), (int)endOffset).shiftRight(elementStartOffset);
            SpringBootApplicationPropertiesAnnotator.doAnnotateEnforced(holder, genericKeyRange, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES, "REGULAR_ITALIC_ATTRIBUTES");
        }
    }

    private static void annotateIndexAccessExpressions(AnnotationHolder holder, String text, SpringBootApplicationMetaConfigKey configKey, int elementStartOffset) {
        int parseOffset = 0;
        int startIdx;
        while ((startIdx = StringUtil.indexOf((CharSequence)text, (char)'[', (int)parseOffset)) != -1) {
            int endIdx;
            parseOffset = endIdx = StringUtil.indexOf((CharSequence)text, (char)']', (int)startIdx);
            if (endIdx == -1) {
                holder.createErrorAnnotation(TextRange.from((int)startIdx, (int)1).shiftRight(elementStartOffset), "Missing closing ']'");
                parseOffset = startIdx + 1;
                continue;
            }
            if (startIdx + 1 == endIdx) {
                holder.createErrorAnnotation(TextRange.from((int)startIdx, (int)2).shiftRight(elementStartOffset), "Missing index value");
                continue;
            }
            SpringBootApplicationPropertiesAnnotator.doAnnotate(holder, TextRange.from((int)startIdx, (int)1).shiftRight(elementStartOffset), DefaultLanguageHighlighterColors.BRACKETS);
            boolean isPlainMapKey = configKey.isAccessType(new SpringBootApplicationMetaConfigKey.AccessType[]{SpringBootApplicationMetaConfigKey.AccessType.MAP});
            if (!isPlainMapKey) {
                TextRange indexValueRange = TextRange.create((int)(startIdx + 1), (int)endIdx);
                String indexValueText = indexValueRange.substring(text);
                try {
                    Integer.decode(indexValueText);
                    SpringBootApplicationPropertiesAnnotator.doAnnotate(holder, indexValueRange.shiftRight(elementStartOffset), DefaultLanguageHighlighterColors.NUMBER);
                }
                catch (NumberFormatException e) {
                    holder.createErrorAnnotation(indexValueRange.shiftRight(elementStartOffset), "Index value must be Integer");
                }
            }
            SpringBootApplicationPropertiesAnnotator.doAnnotate(holder, TextRange.from((int)endIdx, (int)1).shiftRight(elementStartOffset), DefaultLanguageHighlighterColors.BRACKETS);
        }
        return;
    }

    private static void doAnnotate(AnnotationHolder holder, TextRange range, TextAttributesKey key) {
        String message = DEBUG_MODE ? key.getExternalName() : null;
        holder.createInfoAnnotation(range, message).setTextAttributes(key);
    }

    private static void doAnnotateEnforced(AnnotationHolder holder, TextRange range, SimpleTextAttributes key, String debugMessage) {
        String message = DEBUG_MODE ? debugMessage : null;
        holder.createInfoAnnotation(range, message).setEnforcedTextAttributes(key.toTextAttributes());
    }
}

