/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.spring.boot.application.config.SpringBootConfigurationPropertyReferenceSearcher;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.facet.SpringFileSet;
import org.jetbrains.annotations.NotNull;

public class SpringBootApplicationPropertiesConfigurationPropertyReferenceSearcher
extends SpringBootConfigurationPropertyReferenceSearcher {
    protected void processModule(MethodReferencesSearch.SearchParameters queryParameters, String prefix, Module module) {
    }

    protected boolean processFileSet(@NotNull MethodReferencesSearch.SearchParameters queryParameters, PsiManager psiManager, String prefix, SpringFileSet fileSet) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesConfigurationPropertyReferenceSearcher", "processFileSet"));
        }
        for (VirtualFilePointer pointer : fileSet.getPropertiesFiles()) {
            PsiFile psiFile;
            VirtualFile file = pointer.getFile();
            if (file == null || !((psiFile = psiManager.findFile(file)) instanceof PropertiesFile) || !SpringBootApplicationPropertiesUtil.isApplicationPropertiesFile((PropertiesFile)psiFile)) continue;
            PropertiesFile propertiesFile = (PropertiesFile)psiFile;
            for (IProperty property : propertiesFile.getProperties()) {
                PropertyImpl element;
                ASTNode keyNode;
                PsiElement keyPsiElement;
                String propertyName = property.getName();
                if (propertyName == null || !StringUtil.charsEqualIgnoreCase((char)propertyName.charAt(0), (char)prefix.charAt(0)) || (keyPsiElement = (keyNode = (element = (PropertyImpl)property.getPsiElement()).getKeyNode()) != null ? keyNode.getPsi() : null) == null || SpringBootApplicationPropertiesConfigurationPropertyReferenceSearcher.searchMetaConfigKeyReferences((MethodReferencesSearch.SearchParameters)queryParameters, (PsiReference[])keyPsiElement.getReferences())) continue;
                return false;
            }
        }
        return true;
    }
}

