/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationPropertiesUtil {
    public static boolean isApplicationPropertiesFile(PropertiesFile propertiesFile) {
        PsiFile containingFile = propertiesFile.getContainingFile();
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)containingFile, () -> {
            String fileName = propertiesFile.getName();
            if (!("application.properties".equals(fileName) || "bootstrap.properties".equals(fileName) || StringUtil.startsWith((CharSequence)fileName, (CharSequence)"application-") || StringUtil.startsWith((CharSequence)fileName, (CharSequence)"bootstrap-"))) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{containingFile});
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
            boolean springBootAvailable = SpringBootLibraryUtil.hasSpringBootLibrary((Module)module);
            return CachedValueProvider.Result.create((Object)springBootAvailable, (Object[])new Object[]{containingFile, ProjectRootManager.getInstance((Project)propertiesFile.getProject())});
        });
    }

    @Nullable
    static PropertyKeyImpl getPropertyKey(PropertyImpl property) {
        ASTNode keyNode = property.getKeyNode();
        if (keyNode == null) {
            return null;
        }
        PsiElement keyElement = keyNode.getPsi();
        if (!(keyElement instanceof PropertyKeyImpl)) {
            return null;
        }
        return (PropertyKeyImpl)keyElement;
    }

    @Nullable
    static PropertyValueImpl getPropertyValue(PropertyImpl property) {
        ASTNode valueNode = property.getValueNode();
        if (valueNode == null) {
            return null;
        }
        PsiElement valueElement = valueNode.getPsi();
        if (!(valueElement instanceof PropertyValueImpl)) {
            return null;
        }
        return (PropertyValueImpl)valueElement;
    }
}

