/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.facet;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetEditorCustomization;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.util.containers.HashSet;
import icons.SpringBootApiIcons;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

public class SpringBootFileSetEditorCustomization
extends SpringFileSetEditorCustomization {
    public static final String NON_STRICT_SETTING_ID = "spring_boot_non_strict_conditional_eval";
    private static final CustomSetting.BOOLEAN NON_STRICT_CONDITIONAL_SETTING = new CustomSetting.BOOLEAN("spring_boot_non_strict_conditional_eval", "Spring Boot: non-strict @Conditional evaluation", true);

    public boolean isApplicable(SpringFileSet fileSet) {
        return fileSet.isAutodetected() && fileSet.getId().startsWith("spring_boot_");
    }

    public List<SpringFileSetEditorCustomization.CustomConfigFileGroup> getCustomConfigFileGroups(SpringFileSet fileSet) {
        Module module = fileSet.getFacet().getModule();
        HashSet allContributorFiles = new HashSet();
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            allContributorFiles.addAll(contributor.getConfigurationFiles(module));
        }
        LinkedHashSet<VirtualFilePointer> configFiles = new LinkedHashSet<VirtualFilePointer>();
        for (VirtualFilePointer pointer : fileSet.getFiles()) {
            VirtualFile file;
            if (!pointer.isValid() || (file = pointer.getFile()) == null || !allContributorFiles.contains(file)) continue;
            configFiles.add(pointer);
        }
        if (configFiles.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new SpringFileSetEditorCustomization.CustomConfigFileGroup("Configuration Files", SpringBootApiIcons.SpringBoot, configFiles));
    }

    public List<CustomSetting> getCustomSettings() {
        return Collections.singletonList(NON_STRICT_CONDITIONAL_SETTING);
    }
}

