/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.spi.SpringSpiManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AutoConfigClassCollector {
    private static final Comparator<PsiClass> CLASS_NAME_COMPARATOR = (o1, o2) -> StringUtil.compare((String)o1.getQualifiedName(), (String)o2.getQualifiedName(), (boolean)false);
    private final Module myModule;
    private final EnableAutoConfiguration myEnableAutoConfiguration;
    private final PsiClass myConfig;

    AutoConfigClassCollector(Module module, EnableAutoConfiguration enableAutoConfiguration, PsiClass config) {
        this.myModule = module;
        this.myEnableAutoConfiguration = enableAutoConfiguration;
        this.myConfig = config;
    }

    List<PsiClass> getAllAutoConfigurationClasses() {
        List<PsiClass> allAutoConfigurationClasses = AutoConfigClassCollector.getAllRegisteredAutoConfigurationClasses(this.myModule);
        List excludes = this.myEnableAutoConfiguration.getExcludes();
        allAutoConfigurationClasses.removeAll(excludes);
        return AutoConfigClassCollector.sort(allAutoConfigurationClasses);
    }

    private static List<PsiClass> getAllRegisteredAutoConfigurationClasses(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassCollector", "getAllRegisteredAutoConfigurationClasses"));
        }
        if (module.isDisposed()) {
            return Collections.emptyList();
        }
        List allFromConfig = SpringSpiManager.getInstance((Module)module).getClassesListValue(false, "org.springframework.boot.autoconfigure.EnableAutoConfiguration");
        return new ArrayList<PsiClass>(new LinkedHashSet(allFromConfig));
    }

    private static List<PsiClass> sort(List<PsiClass> configs) {
        Collections.sort(configs, CLASS_NAME_COMPARATOR);
        return configs;
    }
}

