/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassCollector;
import com.intellij.spring.boot.model.autoconfigure.AutoConfigClassConditionEvaluator;
import com.intellij.spring.boot.model.autoconfigure.jam.EnableAutoConfiguration;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class EnableAutoConfigurationModel
extends LocalAnnotationModel {
    private final LocalAnnotationModel myLocalAnnotationModel;
    private final EnableAutoConfiguration myEnableAutoConfiguration;
    private final PsiClass myEnableAnnotationClass;

    EnableAutoConfigurationModel(LocalAnnotationModel localAnnotationModel, EnableAutoConfiguration enableAutoConfiguration, PsiClass enableAnnotationClass) {
        this.myEnableAutoConfiguration = enableAutoConfiguration;
        this.myEnableAnnotationClass = enableAnnotationClass;
        this.myLocalAnnotationModel = localAnnotationModel;
    }

    public void setActiveProfiles(@NotNull Set<String> activeProfiles) {
        if (activeProfiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeProfiles", "com/intellij/spring/boot/model/autoconfigure/EnableAutoConfigurationModel", "setActiveProfiles"));
        }
    }

    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        return Collections.emptySet();
    }

    @NotNull
    public PsiClass getConfig() {
        PsiClass psiClass = this.myEnableAnnotationClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/EnableAutoConfigurationModel", "getConfig"));
        }
        return psiClass;
    }

    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        AutoConfigClassCollector collector = new AutoConfigClassCollector(this.getModule(), this.myEnableAutoConfiguration, (PsiClass)this.myLocalAnnotationModel.getConfig());
        List<PsiClass> autoConfigClasses = collector.getAllAutoConfigurationClasses();
        LinkedHashSet autoConfigModels = ContainerUtil.newLinkedHashSet();
        for (PsiClass autoConfigClass : autoConfigClasses) {
            if (!this.processConfigurationClass(autoConfigModels, autoConfigClass)) continue;
            for (PsiClass innerConfig : autoConfigClass.getInnerClasses()) {
                if (!SpringCommonUtils.isConfiguration((PsiClass)innerConfig)) continue;
                this.processConfigurationClass(autoConfigModels, innerConfig);
            }
        }
        LinkedHashSet linkedHashSet = autoConfigModels;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/EnableAutoConfigurationModel", "getDependentLocalModels"));
        }
        return linkedHashSet;
    }

    private boolean processConfigurationClass(Set<Pair<LocalModel, LocalModelDependency>> autoConfigModels, PsiClass autoConfigClass) {
        AutoConfigClassConditionEvaluator evaluator = new AutoConfigClassConditionEvaluator(this.getModule(), autoConfigClass);
        if (!evaluator.isActive()) {
            return false;
        }
        LocalAnnotationModel autoConfigModel = SpringManager.getInstance((Project)this.myEnableAnnotationClass.getProject()).getLocalSpringModel(autoConfigClass, this.getModule());
        if (autoConfigModel == null) {
            return false;
        }
        LocalModelDependency dependency = LocalModelDependency.create((String)("Auto-configuration @" + this.myEnableAnnotationClass.getQualifiedName()), (LocalModelDependencyType)LocalModelDependencyType.ENABLE_ANNO, (PsiElement)autoConfigClass.getNavigationElement());
        autoConfigModels.add((Pair<LocalModel, LocalModelDependency>)Pair.create((Object)autoConfigModel, (Object)dependency));
        return true;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myLocalAnnotationModel.getModule();
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/EnableAutoConfigurationModel", "getModule"));
        }
        return module;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        Set set = this.myLocalAnnotationModel.getAllProfiles();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/EnableAutoConfigurationModel", "getAllProfiles"));
        }
        return set;
    }

    @NotNull
    public Set<PsiFile> getConfigFiles() {
        Set set = this.myLocalAnnotationModel.getConfigFiles();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/EnableAutoConfigurationModel", "getConfigFiles"));
        }
        return set;
    }

    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFile", "com/intellij/spring/boot/model/autoconfigure/EnableAutoConfigurationModel", "hasConfigFile"));
        }
        return this.myLocalAnnotationModel.hasConfigFile(configFile);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EnableAutoConfigurationModel model = (EnableAutoConfigurationModel)((Object)o);
        if (!this.myEnableAnnotationClass.equals(model.myEnableAnnotationClass)) {
            return false;
        }
        return this.myLocalAnnotationModel.equals(model.myLocalAnnotationModel);
    }

    public int hashCode() {
        int result = this.myEnableAnnotationClass.hashCode();
        result = 31 * result + this.myLocalAnnotationModel.hashCode();
        return result;
    }
}

