/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.JavaeeBundle;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.admin.JavaeeAdminClientImpl;
import com.intellij.javaee.oss.jetty.JettyBundle;
import com.intellij.javaee.oss.jetty.admin.JettyAdminServerImpl;
import com.intellij.javaee.oss.jetty.server.JettyContextDeploymentMethod;
import com.intellij.javaee.oss.jetty.server.JettyDeployTarget;
import com.intellij.javaee.oss.jetty.server.JettyDeploymentModel;
import com.intellij.javaee.oss.jetty.server.JettyModelData;
import com.intellij.javaee.oss.jetty.version.JettyVersion6Handler;
import com.intellij.javaee.oss.jetty.version.JettyVersion741Handler;
import com.intellij.javaee.oss.jetty.version.JettyVersion7Handler;
import com.intellij.javaee.oss.jetty.version.JettyVersion91Handler;
import com.intellij.javaee.oss.jetty.version.JettyVersion9Handler;
import com.intellij.javaee.oss.jetty.version.JettyVersionHandler;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.Version;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public abstract class JettyServerModel<T extends JettyModelData>
extends JavaeeServerModel {
    private static final JettyVersionHandler VERSION_6_HANDLER = new JettyVersion6Handler();
    private static final JettyVersionHandler VERSION_7_HANDLER = new JettyVersion7Handler();
    private static final JettyVersionHandler VERSION_741_HANDLER = new JettyVersion741Handler();
    private static final JettyVersionHandler VERSION_9_HANDLER = new JettyVersion9Handler();
    private static final JettyVersionHandler VERSION_91_HANDLER = new JettyVersion91Handler();
    @NonNls
    protected static final String DATA_ELEMENT = "data";
    public static final int DEFAULT_JNDI_PORT = 1099;
    public int JNDI_PORT = 1099;
    @NonNls
    private static final String JETTY_LOG_FILE_ID = "Jetty";

    protected String getLogFileId() {
        return JETTY_LOG_FILE_ID;
    }

    @NonNls
    protected String getDefaultUsername() {
        return JettyServerModel.doGetDefaultUsername();
    }

    @NonNls
    protected String getDefaultPassword() {
        return JettyServerModel.doGetDefaultPassword();
    }

    @NonNls
    protected static String doGetDefaultUsername() {
        return "";
    }

    @NonNls
    protected static String doGetDefaultPassword() {
        return "";
    }

    protected JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
        return new JavaeeAdminClientImpl((JavaeeAdmin)new JettyAdminServerImpl(this.getVersionHandler()));
    }

    protected List<File> getLibraries() throws ExecutionException {
        List libraries = super.getLibraries();
        libraries.add(this.getPathUnderHome("lib"));
        return libraries;
    }

    public int getServerPort() {
        return this.JNDI_PORT;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        if (this.JNDI_PORT <= 0) {
            throw new RuntimeConfigurationError(JettyBundle.getText("JettyServerModel.error.jmx", new Object[0]));
        }
        HashSet<String> contexts = new HashSet<String>();
        for (DeploymentModel deploymentModel : this.getCommonModel().getDeploymentModels()) {
            String contextPath;
            JettyDeploymentModel jettyDeploymentModel = (JettyDeploymentModel)deploymentModel;
            if (!(jettyDeploymentModel.getDeploymentMethod() instanceof JettyContextDeploymentMethod) || jettyDeploymentModel.isDefaultContextRoot() || contexts.add(contextPath = jettyDeploymentModel.getContextRoot())) continue;
            throw new RuntimeConfigurationError(JavaeeBundle.getText((String)"JettyServerModel.error.duplicate.context.path.text", (Object[])new Object[]{contextPath}));
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element dataElement = element.getChild(DATA_ELEMENT);
        if (dataElement == null) {
            super.readExternal(element);
        } else {
            JettyModelData settings = (JettyModelData)XmlSerializer.deserialize((Element)dataElement, this.getDataClass());
            this.readFromData(settings);
            this.JNDI_PORT = settings.getJndiPort();
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        T settings = this.createData();
        this.writeToData(settings);
        settings.setJndiPort(this.JNDI_PORT);
        Element dataElement = XmlSerializer.serialize(settings, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        element.addContent(dataElement);
    }

    public static JettyVersionHandler getVersionHandler(String versionText) {
        if (StringUtil.isEmpty((String)versionText)) {
            return VERSION_91_HANDLER;
        }
        Version version = new Version(versionText);
        if (version.compare(9, 1, 0) >= 0) {
            return VERSION_91_HANDLER;
        }
        if (version.compare(9, 0, 0) >= 0) {
            return VERSION_9_HANDLER;
        }
        if (version.compare(7, 4, 1) >= 0) {
            return VERSION_741_HANDLER;
        }
        if (version.compare(7, 0, 0) >= 0) {
            return VERSION_7_HANDLER;
        }
        return VERSION_6_HANDLER;
    }

    public JettyVersionHandler getVersionHandler() {
        return JettyServerModel.getVersionHandler(this.getVersion());
    }

    public String getServerSpecificContext(File source) {
        return JettyServerModel.cutWarExtension((File)source);
    }

    public abstract boolean transferFile(File var1, JettyDeployTarget var2);

    public abstract boolean deleteFile(File var1, JettyDeployTarget var2);

    protected abstract Class<T> getDataClass();

    protected abstract T createData();

    protected abstract void readFromData(T var1);

    protected abstract void writeToData(T var1);
}

