/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jetty.version;

import com.intellij.javaee.deployment.DeploymentStatus;
import com.intellij.javaee.oss.jetty.model.JettyConfigArgElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigCallElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigNewElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigRefElement;
import com.intellij.javaee.oss.jetty.model.JettyConfigSetElement;
import com.intellij.javaee.oss.jetty.model.JettyWebRootElement;
import com.intellij.javaee.oss.jetty.server.JettyConfigFileWriter;
import com.intellij.javaee.oss.jetty.version.JettyVersion741Handler;
import com.intellij.javaee.oss.util.AbstractConnectorCommand;
import java.io.File;
import java.io.IOException;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class JettyVersion9Handler
extends JettyVersion741Handler {
    @Override
    protected JettyConfigFileWriter getConfigFileWriter(final File contextDeployTempDir) {
        return new JettyConfigFileWriter(){

            @Override
            protected void createContent(JettyWebRootElement rootElement) {
                rootElement.getId().setValue((Object)"Server");
                JettyConfigRefElement refElement = rootElement.addRef();
                refElement.getId().setValue((Object)"DeploymentManager");
                JettyConfigCallElement callElement = refElement.addCall();
                callElement.getName().setValue((Object)"addAppProvider");
                JettyConfigArgElement argElement = callElement.addArg();
                JettyConfigNewElement newElement = 1.setupNewElement(argElement, JettyVersion9Handler.this.getContextDeployerPackageName() + ".WebAppProvider");
                JettyConfigSetElement setDirElement = 1.setupSetElement(newElement, "monitoredDirName");
                setDirElement.setValue(contextDeployTempDir.getAbsolutePath());
                1.setupScanIntervalSetElement(newElement);
            }
        };
    }

    @Override
    public DeploymentStatus getDeploymentStatus(MBeanServerConnection connection, ObjectName objectName) throws IOException, JMException {
        String stateDescription = (String)AbstractConnectorCommand.getAttribute((MBeanServerConnection)connection, (ObjectName)objectName, (String)"state");
        if ("started".equalsIgnoreCase(stateDescription)) {
            return DeploymentStatus.DEPLOYED;
        }
        if ("stopped".equalsIgnoreCase(stateDescription)) {
            return DeploymentStatus.NOT_DEPLOYED;
        }
        if ("starting".equalsIgnoreCase(stateDescription)) {
            return DeploymentStatus.ACTIVATING;
        }
        return DeploymentStatus.FAILED;
    }

    @Override
    public boolean isStarted(MBeanServerConnection connection) throws IOException, JMException {
        String stateDescription = (String)AbstractConnectorCommand.getAttribute((MBeanServerConnection)connection, (ObjectName)this.getServerObjectName(), (String)"state");
        return "started".equalsIgnoreCase(stateDescription);
    }

    @Override
    public String getHttpPortConfigFilePath() {
        return "etc/jetty-http.xml";
    }

    @Override
    protected String getContextsConfigFilename() {
        return "jetty-contexts.xml";
    }

    @Override
    protected String getContextDeployerPackageName() {
        return "org.eclipse.jetty.deploy.providers";
    }

    @Override
    protected String getWebAppClassAttributeName() {
        return "context";
    }

    @Override
    public String getConfigDocTypeSystemId() {
        return "http://www.eclipse.org/jetty/configure_9_0.dtd";
    }
}

