/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopElementBase;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.AopTypeExpression;
import com.intellij.aop.psi.AopTypeParameterList;
import com.intellij.aop.psi.GenericPattern;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AopGenericTypeExpression
extends AopElementBase
implements AopTypeExpression {
    public AopGenericTypeExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/AopGenericTypeExpression", "<init>"));
        }
        super(node);
    }

    public String toString() {
        return "AopParameterizedTypeExpression";
    }

    @NotNull
    public AopTypeExpression getRawTypeReference() {
        AopTypeExpression aopTypeExpression = (AopTypeExpression)this.findNotNullChildByClass(AopTypeExpression.class);
        if (aopTypeExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopGenericTypeExpression", "getRawTypeReference"));
        }
        return aopTypeExpression;
    }

    @NotNull
    public AopTypeParameterList getTypeParameterList() {
        AopTypeParameterList aopTypeParameterList = (AopTypeParameterList)((Object)this.findNotNullChildByClass(AopTypeParameterList.class));
        if (aopTypeParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopGenericTypeExpression", "getTypeParameterList"));
        }
        return aopTypeParameterList;
    }

    @Override
    @NotNull
    public Collection<AopPsiTypePattern> getPatterns() {
        Collection<AopPsiTypePattern> erasurePatterns = this.getRawTypeReference().getPatterns();
        PsiElement[] parameters = this.getTypeParameterList().getParameters();
        AopPsiTypePattern[][] parameterPatterns = new AopPsiTypePattern[parameters.length][];
        for (int i = 0; i < parameters.length; ++i) {
            AopTypeExpression expression = ((AopReferenceHolder)parameters[i]).getTypeExpression();
            if (expression == null) {
                List<AopPsiTypePattern> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopGenericTypeExpression", "getPatterns"));
                }
                return list;
            }
            Collection<AopPsiTypePattern> patterns = expression.getPatterns();
            parameterPatterns[i] = patterns.toArray(new AopPsiTypePattern[patterns.size()]);
        }
        THashSet result = new THashSet();
        block1: for (AopPsiTypePattern erasurePattern : erasurePatterns) {
            int[] indices = new int[parameterPatterns.length];
            block2: while (true) {
                int j;
                AopPsiTypePattern[] paramVariant = new AopPsiTypePattern[parameterPatterns.length];
                for (int i = 0; i < paramVariant.length; ++i) {
                    paramVariant[i] = parameterPatterns[i][indices[i]];
                }
                result.add(new GenericPattern(erasurePattern, paramVariant));
                for (j = indices.length - 1; j >= 0 && indices[j] == parameterPatterns[j].length - 1; --j) {
                }
                if (j < 0) continue block1;
                int n = j;
                indices[n] = indices[n] + 1;
                while (true) {
                    if (++j >= indices.length) continue block2;
                    indices[j] = 0;
                }
                break;
            }
        }
        THashSet tHashSet = result;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/AopGenericTypeExpression", "getPatterns"));
        }
        return tHashSet;
    }

    @Override
    public String getTypePattern() {
        return "'_";
    }
}

