/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.aop.psi.WildcardPattern;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

public class GenericPattern
extends AopPsiTypePattern {
    private final AopPsiTypePattern myErasure;
    private final AopPsiTypePattern[] myParameters;

    public GenericPattern(AopPsiTypePattern erasure, AopPsiTypePattern ... parameters) {
        this.myErasure = erasure;
        this.myParameters = parameters;
    }

    public AopPsiTypePattern getErasure() {
        return this.myErasure;
    }

    public AopPsiTypePattern[] getParameters() {
        return this.myParameters;
    }

    @Override
    public boolean accepts(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/aop/psi/GenericPattern", "accepts"));
        }
        return this.accepts(type, false);
    }

    private boolean accepts(@NotNull PsiType type, boolean allowWildcardAssignability) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/aop/psi/GenericPattern", "accepts"));
        }
        if (type instanceof PsiClassType) {
            if (!this.myErasure.accepts(type)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            if (classType.isRaw()) {
                return allowWildcardAssignability;
            }
            PsiType[] parameters = classType.getParameters();
            if (this.myParameters.length != parameters.length) {
                return false;
            }
            for (int i = 0; i < parameters.length; ++i) {
                AopPsiTypePattern paramPattern = this.myParameters[i];
                PsiType parameter = parameters[i];
                if (!allowWildcardAssignability || !(paramPattern instanceof WildcardPattern) ? paramPattern.accepts(parameter) : paramPattern.canBeAssignableFrom(parameter) == PointcutMatchDegree.TRUE) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public PointcutMatchDegree canBeAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/aop/psi/GenericPattern", "canBeAssignableFrom"));
        }
        if (this.accepts(type, true)) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.TRUE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/GenericPattern", "canBeAssignableFrom"));
            }
            return pointcutMatchDegree;
        }
        boolean maybe = false;
        for (PsiType psiType : type.getSuperTypes()) {
            PointcutMatchDegree degree = this.canBeAssignableFrom(psiType);
            if (degree == PointcutMatchDegree.TRUE) {
                PointcutMatchDegree pointcutMatchDegree = degree;
                if (pointcutMatchDegree == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/GenericPattern", "canBeAssignableFrom"));
                }
                return pointcutMatchDegree;
            }
            maybe = degree == PointcutMatchDegree.MAYBE;
        }
        PointcutMatchDegree pointcutMatchDegree = maybe ? PointcutMatchDegree.MAYBE : PointcutMatchDegree.FALSE;
        if (pointcutMatchDegree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/GenericPattern", "canBeAssignableFrom"));
        }
        return pointcutMatchDegree;
    }
}

