/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.NotPattern;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiAnnotatedTypePattern
extends AopPsiTypePattern {
    private final AopPsiTypePattern myAnnotationPattern;

    public PsiAnnotatedTypePattern(AopPsiTypePattern annotationPattern) {
        this.myAnnotationPattern = annotationPattern;
    }

    public AopPsiTypePattern getAnnotationPattern() {
        return this.myAnnotationPattern;
    }

    @Override
    public boolean accepts(@NotNull PsiType type) {
        PsiClass psiClass;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/aop/psi/PsiAnnotatedTypePattern", "accepts"));
        }
        return type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && PsiAnnotatedTypePattern.acceptsAnnotationPattern((PsiModifierListOwner)psiClass, this.myAnnotationPattern, false);
    }

    public static boolean acceptsAnnotationPattern(@NotNull PsiModifierListOwner owner, AopPsiTypePattern annoPattern, boolean shoulBeInherited) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/aop/psi/PsiAnnotatedTypePattern", "acceptsAnnotationPattern"));
        }
        return PsiAnnotatedTypePattern.acceptsAnnotationPattern(owner, annoPattern, shoulBeInherited, (Set<PsiModifierListOwner>)new THashSet());
    }

    private static boolean acceptsAnnotationPattern(PsiModifierListOwner owner, AopPsiTypePattern annoPattern, boolean shoulBeInherited, Set<PsiModifierListOwner> visited) {
        visited.add(owner);
        if (annoPattern instanceof NotPattern) {
            return !PsiAnnotatedTypePattern.acceptsAnnotationPattern(owner, ((NotPattern)annoPattern).getInnerPattern(), shoulBeInherited);
        }
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                String qualifiedName;
                PsiElement psiElement;
                PsiJavaCodeReferenceElement element = annotation.getNameReferenceElement();
                if (element != null && (psiElement = element.resolve()) instanceof PsiClass) {
                    PsiClass annoClass = (PsiClass)psiElement;
                    if (annoPattern.accepts((PsiType)JavaPsiFacade.getInstance((Project)psiElement.getProject()).getElementFactory().createType(annoClass))) {
                        PsiModifierList list = annoClass.getModifierList();
                        return !shoulBeInherited || list != null && list.findAnnotation("java.lang.annotation.Inherited") != null;
                    }
                }
                if ((qualifiedName = annotation.getQualifiedName()) == null || !annoPattern.accepts(qualifiedName)) continue;
                return true;
            }
        }
        if (owner instanceof PsiClass) {
            PsiClass superClass = ((PsiClass)owner).getSuperClass();
            return superClass != null && !visited.contains(superClass) && PsiAnnotatedTypePattern.acceptsAnnotationPattern((PsiModifierListOwner)superClass, annoPattern, true);
        }
        return false;
    }

    @Override
    @NotNull
    public PointcutMatchDegree canBeAssignableFrom(@NotNull PsiType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/aop/psi/PsiAnnotatedTypePattern", "canBeAssignableFrom"));
        }
        PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.valueOf(this.accepts(type));
        if (pointcutMatchDegree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiAnnotatedTypePattern", "canBeAssignableFrom"));
        }
        return pointcutMatchDegree;
    }
}

