/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.psi;

import com.intellij.aop.psi.AopAnnotationHolder;
import com.intellij.aop.psi.AopMemberReferenceExpression;
import com.intellij.aop.psi.AopModifierList;
import com.intellij.aop.psi.AopParameterList;
import com.intellij.aop.psi.AopPsiTypePattern;
import com.intellij.aop.psi.AopReferenceExpression;
import com.intellij.aop.psi.AopReferenceHolder;
import com.intellij.aop.psi.AopReferenceTarget;
import com.intellij.aop.psi.AopThrowsList;
import com.intellij.aop.psi.MethodPatternPointcut;
import com.intellij.aop.psi.PointcutContext;
import com.intellij.aop.psi.PointcutMatchDegree;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiExecutionExpression
extends MethodPatternPointcut {
    public static final AopParameterList.TypeArgumentMatcher NO_AUTOBOXING = new AopParameterList.TypeArgumentMatcher(){

        @Override
        public PointcutMatchDegree matches(PsiParameter psiParameter, AopReferenceTarget holder) {
            return holder.accepts(psiParameter.getType());
        }
    };

    public PsiExecutionExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/aop/psi/PsiExecutionExpression", "<init>"));
        }
        super(node);
    }

    public String toString() {
        return "PsiExecutionExpression";
    }

    @Override
    @NotNull
    public PointcutMatchDegree acceptsSubject(PointcutContext context, PsiMember member) {
        if (!(member instanceof PsiMethod)) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiExecutionExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        AopMemberReferenceExpression methodReference = this.getMethodReference();
        if (methodReference == null) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiExecutionExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        PsiMethod method = (PsiMethod)member;
        AopReferenceExpression expression = methodReference.getReferenceExpression();
        if (expression == null || !expression.getRegex().matcher(method.getName()).matches()) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiExecutionExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        AopModifierList modifierList = this.getModifierList();
        AopParameterList parameterList = this.getParameterList();
        AopReferenceHolder returnType = this.getReturnType();
        AopThrowsList throwsList = this.getThrowsList();
        AopAnnotationHolder annotationHolder = this.getAnnotationHolder();
        if (modifierList != null && !modifierList.accepts((PsiModifierListOwner)member)) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiExecutionExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        if (!PsiExecutionExpression.acceptsReturnType(returnType, method.getReturnType())) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiExecutionExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        if (throwsList != null && !throwsList.matches(method.getThrowsList())) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiExecutionExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        if (parameterList != null && parameterList.matches(context, method.getParameterList(), NO_AUTOBOXING) != PointcutMatchDegree.TRUE) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiExecutionExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        if (annotationHolder != null && !annotationHolder.accepts((PsiModifierListOwner)method)) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiExecutionExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        if (PsiExecutionExpression.processClass(member.getContainingClass(), method, (Set<PsiClass>)new THashSet(), methodReference.getPatterns())) {
            PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.TRUE;
            if (pointcutMatchDegree == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiExecutionExpression", "acceptsSubject"));
            }
            return pointcutMatchDegree;
        }
        PointcutMatchDegree pointcutMatchDegree = PointcutMatchDegree.FALSE;
        if (pointcutMatchDegree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/psi/PsiExecutionExpression", "acceptsSubject"));
        }
        return pointcutMatchDegree;
    }

    private static boolean processClass(PsiClass aClass, PsiMethod method, Set<PsiClass> visited, Collection<AopPsiTypePattern> patterns) {
        PsiMethod psiMethod = aClass.findMethodBySignature(method, true);
        if (psiMethod == null) {
            return false;
        }
        if (PsiExecutionExpression.acceptsMethodClassAndName(aClass, patterns)) {
            return true;
        }
        visited.add(aClass);
        PsiClass superClass = aClass.getSuperClass();
        if (superClass != null && !visited.contains(superClass) && PsiExecutionExpression.processClass(superClass, method, visited, patterns)) {
            return true;
        }
        for (PsiClass intf : aClass.getInterfaces()) {
            if (visited.contains(intf) || !PsiExecutionExpression.processClass(intf, method, visited, patterns)) continue;
            return true;
        }
        return false;
    }

    private static boolean acceptsMethodClassAndName(@NotNull PsiClass declaringClass, Collection<AopPsiTypePattern> patterns) {
        if (declaringClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaringClass", "com/intellij/aop/psi/PsiExecutionExpression", "acceptsMethodClassAndName"));
        }
        return AopPsiTypePattern.accepts(patterns, (PsiType)JavaPsiFacade.getInstance((Project)declaringClass.getProject()).getElementFactory().createType(declaringClass)) == PointcutMatchDegree.TRUE;
    }

    private static boolean acceptsReturnType(AopReferenceHolder returnType, PsiType methodReturnType) {
        if (returnType == null || methodReturnType == null) {
            return true;
        }
        return returnType.accepts(methodReturnType) == PointcutMatchDegree.TRUE;
    }
}

