/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.nashorn.smartstep;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.javascript.debugger.nashorn.NashornPositionManagerFactory;
import com.intellij.javascript.debugger.nashorn.smartstep.JSSmartStepTarget;
import com.intellij.javascript.debugger.nashorn.smartstep.NashornMethodFilter;
import com.intellij.lang.javascript.hierarchy.JSHierarchyUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NashornSmartStepIntoHandler
extends JvmSmartStepIntoHandler {
    public boolean isAvailable(SourcePosition position) {
        return NashornPositionManagerFactory.isNashornApplicable(position);
    }

    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(SourcePosition position) {
        int line = position.getLine();
        if (line < 0) {
            List<SmartStepTarget> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/smartstep/NashornSmartStepIntoHandler", "findSmartStepTargets"));
            }
            return list;
        }
        PsiFile file = position.getFile();
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null) {
            List<SmartStepTarget> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/smartstep/NashornSmartStepIntoHandler", "findSmartStepTargets"));
            }
            return list;
        }
        Document doc = FileDocumentManager.getInstance().getDocument(vFile);
        if (doc == null) {
            List<SmartStepTarget> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/smartstep/NashornSmartStepIntoHandler", "findSmartStepTargets"));
            }
            return list;
        }
        if (line >= doc.getLineCount()) {
            List<SmartStepTarget> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/smartstep/NashornSmartStepIntoHandler", "findSmartStepTargets"));
            }
            return list;
        }
        int startOffset = doc.getLineStartOffset(line);
        final TextRange lineRange = new TextRange(startOffset, doc.getLineEndOffset(line));
        int offset = CharArrayUtil.shiftForward((CharSequence)doc.getCharsSequence(), (int)startOffset, (String)" \t");
        PsiElement element = file.findElementAt(offset);
        if (element != null && !(element instanceof PsiCompiledElement)) {
            PsiElement parent;
            while ((parent = element.getParent()) != null && parent.getTextOffset() >= lineRange.getStartOffset()) {
                element = parent;
            }
            OrderedSet targets = new OrderedSet();
            Range lines = new Range((Comparable)Integer.valueOf(doc.getLineNumber(element.getTextOffset())), (Comparable)Integer.valueOf(doc.getLineNumber(element.getTextOffset() + element.getTextLength())));
            JSRecursiveElementVisitor methodCollector = new JSRecursiveElementVisitor((List)targets, lines){
                final Stack<PsiElement> myContextStack = new Stack();
                final Stack<String> myParamNameStack = new Stack();
                private int myNextLambdaExpressionOrdinal = 0;
                final /* synthetic */ List val$targets;
                final /* synthetic */ Range val$lines;
                {
                    this.val$targets = list;
                    this.val$lines = range;
                }

                @Nullable
                private String getCurrentParamName() {
                    return this.myParamNameStack.isEmpty() ? null : (String)this.myParamNameStack.peek();
                }

                public void visitJSStatement(JSStatement statement) {
                    if (lineRange.intersects(statement.getTextRange())) {
                        super.visitJSStatement(statement);
                    }
                }

                public void visitJSCallExpression(JSCallExpression expression) {
                    this.myContextStack.push((Object)expression);
                    this.val$targets.add(new JSSmartStepTarget(expression.getMethodExpression().getText(), (PsiElement)expression, JSHierarchyUtils.getJSFunction((JSCallExpression)expression), false, (Range<Integer>)this.val$lines));
                    try {
                        super.visitJSCallExpression(expression);
                    }
                    finally {
                        this.myContextStack.pop();
                    }
                }
            };
            element.accept((PsiElementVisitor)methodCollector);
            for (PsiElement sibling = element.getNextSibling(); sibling != null && lineRange.intersects(sibling.getTextRange()); sibling = sibling.getNextSibling()) {
                sibling.accept((PsiElementVisitor)methodCollector);
            }
            OrderedSet orderedSet = targets;
            if (orderedSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/smartstep/NashornSmartStepIntoHandler", "findSmartStepTargets"));
            }
            return orderedSet;
        }
        List<SmartStepTarget> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/debugger/nashorn/smartstep/NashornSmartStepIntoHandler", "findSmartStepTargets"));
        }
        return list;
    }

    @Nullable
    protected MethodFilter createMethodFilter(SmartStepTarget stepTarget) {
        JSFunction function;
        if (stepTarget instanceof JSSmartStepTarget && (function = ((JSSmartStepTarget)stepTarget).getFunction()) != null) {
            return new NashornMethodFilter(function, (Range<Integer>)stepTarget.getCallingExpressionLines());
        }
        return null;
    }
}

