/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.jdi;

import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.debugger.jdi.JdiObject;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.BasicDebuggerViewSupport;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;

public class JavaDebuggerViewSupport
extends BasicDebuggerViewSupport {
    public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport", "computeObjectPresentation"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport", "computeObjectPresentation"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport", "computeObjectPresentation"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport", "computeObjectPresentation"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport", "computeObjectPresentation"));
        }
        node.setPresentation(icon, (XValuePresentation)new JavaObjectPresentation(((JdiObject)value).getReference()), value.hasProperties() != ThreeState.NO);
    }

    public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport", "computeArrayPresentation"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport", "computeArrayPresentation"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport", "computeArrayPresentation"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport", "computeArrayPresentation"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport", "computeArrayPresentation"));
        }
        this.computeObjectPresentation((ObjectValue)value, variable, context, node, icon);
    }

    private static boolean isEnumConstant(ObjectReference objRef) {
        Type type = objRef.type();
        return type instanceof ClassType && ((ClassType)type).isEnum();
    }

    private static final class JavaObjectPresentation
    extends XValuePresentation {
        private final ObjectReference reference;

        private JavaObjectPresentation(@NotNull ObjectReference reference) {
            if (reference == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport$JavaObjectPresentation", "<init>"));
            }
            this.reference = reference;
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/jetbrains/debugger/jdi/JavaDebuggerViewSupport$JavaObjectPresentation", "renderValue"));
            }
            ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
            boolean showConcreteType = !classRenderer.SHOW_DECLARED_TYPE || !(this.reference instanceof StringReference) && !(this.reference instanceof ClassObjectReference) && !JavaDebuggerViewSupport.isEnumConstant(this.reference);
            boolean isArray = this.reference instanceof ArrayReference;
            if (showConcreteType) {
                String typeName = classRenderer.renderTypeName(this.reference.type().name());
                String postfix = "[]";
                if (isArray && typeName.endsWith(postfix)) {
                    typeName = typeName.substring(0, typeName.length() - postfix.length());
                }
                renderer.renderComment(typeName);
            }
            if (isArray) {
                renderer.renderComment("[");
                renderer.renderComment(Integer.toString(((ArrayReference)this.reference).length()));
                renderer.renderComment("]");
            }
            if (classRenderer.SHOW_OBJECT_ID) {
                renderer.renderComment("@");
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    renderer.renderComment("uniqueID");
                } else {
                    renderer.renderComment(String.valueOf(this.reference.uniqueID()));
                }
            }
            if (this.reference instanceof ClassObjectReference) {
                renderer.renderSpecialSymbol(" ");
                renderer.renderSpecialSymbol(((ClassObjectReference)this.reference).reflectedType().name());
            }
        }
    }
}

