/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.EnumSet;
import java.util.Locale;

public class ResourceEvaluator {
    public static final ResourceType COLOR_INT_MARKER_TYPE = ResourceType.PUBLIC;
    public static final ResourceType PX_MARKER_TYPE = ResourceType.DECLARE_STYLEABLE;
    public static final String COLOR_INT_ANNOTATION = "android.support.annotation.ColorInt";
    public static final String PX_ANNOTATION = "android.support.annotation.Px";
    public static final String RES_SUFFIX = "Res";
    private final JavaEvaluator mEvaluator;
    private boolean mAllowDereference = true;

    public ResourceEvaluator(JavaEvaluator evaluator) {
        this.mEvaluator = evaluator;
    }

    public ResourceEvaluator allowDereference(boolean allow) {
        this.mAllowDereference = allow;
        return this;
    }

    public static ResourceUrl getResource(JavaEvaluator evaluator, PsiElement element) {
        return new ResourceEvaluator(evaluator).getResource(element);
    }

    public static EnumSet<ResourceType> getResourceTypes(JavaEvaluator evaluator, PsiElement element) {
        return new ResourceEvaluator(evaluator).getResourceTypes(element);
    }

    public ResourceUrl getResource(PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression = (PsiConditionalExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (PsiElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.getResource((PsiElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.getResource((PsiElement)expression.getElseExpression());
            }
        } else {
            if (element instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
                return this.getResource((PsiElement)parenthesizedExpression.getExpression());
            }
            if (element instanceof PsiMethodCallExpression && this.mAllowDereference) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)element;
                PsiReferenceExpression expression = call.getMethodExpression();
                PsiMethod method = call.resolveMethod();
                if (method != null && method.getContainingClass() != null) {
                    PsiExpression[] args;
                    String qualifiedName = method.getContainingClass().getQualifiedName();
                    String name = expression.getReferenceName();
                    if (("android.content.res.Resources".equals(qualifiedName) || "android.content.Context".equals(qualifiedName) || "android.app.Fragment".equals(qualifiedName) || "android.support.v4.app.Fragment".equals(qualifiedName) || "android.content.res.TypedArray".equals(qualifiedName)) && name != null && name.startsWith("get") && (args = call.getArgumentList().getExpressions()).length > 0) {
                        return this.getResource((PsiElement)args[0]);
                    }
                }
            } else if (element instanceof PsiReference) {
                ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
                if (url != null) {
                    return url;
                }
                PsiElement resolved = ((PsiReference)element).resolve();
                if (resolved instanceof PsiField) {
                    url = ResourceEvaluator.getResourceConstant(resolved);
                    if (url != null) {
                        return url;
                    }
                    PsiField field = (PsiField)resolved;
                    if (field.getInitializer() != null) {
                        return this.getResource((PsiElement)field.getInitializer());
                    }
                    return null;
                }
                if (resolved instanceof PsiLocalVariable) {
                    PsiLocalVariable variable = (PsiLocalVariable)resolved;
                    PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)false);
                    if (statement != null) {
                        PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                        String targetName = variable.getName();
                        if (targetName == null) {
                            return null;
                        }
                        while (prev != null) {
                            PsiReferenceExpression reference;
                            PsiAssignmentExpression assign;
                            PsiExpression lhs;
                            PsiExpression expression;
                            if (prev instanceof PsiDeclarationStatement) {
                                PsiDeclarationStatement prevStatement = (PsiDeclarationStatement)prev;
                                for (PsiElement e : prevStatement.getDeclaredElements()) {
                                    if (!variable.equals(e)) continue;
                                    return this.getResource((PsiElement)variable.getInitializer());
                                }
                            } else if (prev instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                                return this.getResource((PsiElement)assign.getRExpression());
                            }
                            prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
                        }
                    }
                }
            }
        }
        return null;
    }

    public EnumSet<ResourceType> getResourceTypes(PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof PsiConditionalExpression) {
            PsiConditionalExpression expression = (PsiConditionalExpression)element;
            Object known = ConstantEvaluator.evaluate(null, (PsiElement)expression.getCondition());
            if (known == Boolean.TRUE && expression.getThenExpression() != null) {
                return this.getResourceTypes((PsiElement)expression.getThenExpression());
            }
            if (known == Boolean.FALSE && expression.getElseExpression() != null) {
                return this.getResourceTypes((PsiElement)expression.getElseExpression());
            }
            EnumSet<ResourceType> left = this.getResourceTypes((PsiElement)expression.getThenExpression());
            EnumSet<ResourceType> right = this.getResourceTypes((PsiElement)expression.getElseExpression());
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            EnumSet<ResourceType> copy = EnumSet.copyOf(left);
            copy.addAll(right);
            return copy;
        }
        if (element instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
            return this.getResourceTypes((PsiElement)parenthesizedExpression.getExpression());
        }
        if (element instanceof PsiMethodCallExpression && this.mAllowDereference) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)element;
            PsiReferenceExpression expression = call.getMethodExpression();
            PsiMethod method = call.resolveMethod();
            if (method != null && method.getContainingClass() != null) {
                PsiExpression[] args;
                EnumSet<ResourceType> types = this.getTypesFromAnnotations((PsiModifierListOwner)method);
                if (types != null) {
                    return types;
                }
                String qualifiedName = method.getContainingClass().getQualifiedName();
                String name = expression.getReferenceName();
                if (("android.content.res.Resources".equals(qualifiedName) || "android.content.Context".equals(qualifiedName) || "android.app.Fragment".equals(qualifiedName) || "android.support.v4.app.Fragment".equals(qualifiedName) || "android.content.res.TypedArray".equals(qualifiedName)) && name != null && name.startsWith("get") && (args = call.getArgumentList().getExpressions()).length > 0 && (types = this.getResourceTypes((PsiElement)args[0])) != null) {
                    return types;
                }
            }
        } else if (element instanceof PsiReference) {
            ResourceUrl url = ResourceEvaluator.getResourceConstant(element);
            if (url != null) {
                return EnumSet.of(url.type);
            }
            PsiElement resolved = ((PsiReference)element).resolve();
            if (resolved instanceof PsiField) {
                url = ResourceEvaluator.getResourceConstant(resolved);
                if (url != null) {
                    return EnumSet.of(url.type);
                }
                PsiField field = (PsiField)resolved;
                if (field.getInitializer() != null) {
                    return this.getResourceTypes((PsiElement)field.getInitializer());
                }
                return null;
            }
            if (resolved instanceof PsiParameter) {
                return this.getTypesFromAnnotations((PsiModifierListOwner)((PsiParameter)resolved));
            }
            if (resolved instanceof PsiLocalVariable) {
                PsiLocalVariable variable = (PsiLocalVariable)resolved;
                PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)false);
                if (statement != null) {
                    PsiStatement prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class);
                    String targetName = variable.getName();
                    if (targetName == null) {
                        return null;
                    }
                    while (prev != null) {
                        PsiReferenceExpression reference;
                        PsiAssignmentExpression assign;
                        PsiExpression lhs;
                        PsiExpression expression;
                        if (prev instanceof PsiDeclarationStatement) {
                            PsiDeclarationStatement prevStatement = (PsiDeclarationStatement)prev;
                            for (PsiElement e : prevStatement.getDeclaredElements()) {
                                if (!variable.equals(e)) continue;
                                return this.getResourceTypes((PsiElement)variable.getInitializer());
                            }
                        } else if (prev instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)prev).getExpression()) instanceof PsiAssignmentExpression && (lhs = (assign = (PsiAssignmentExpression)expression).getLExpression()) instanceof PsiReferenceExpression && targetName.equals((reference = (PsiReferenceExpression)lhs).getReferenceName()) && reference.getQualifier() == null) {
                            return this.getResourceTypes((PsiElement)assign.getRExpression());
                        }
                        prev = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prev, PsiStatement.class);
                    }
                }
            }
        }
        return null;
    }

    private EnumSet<ResourceType> getTypesFromAnnotations(PsiModifierListOwner owner) {
        if (this.mEvaluator == null) {
            return null;
        }
        for (PsiAnnotation annotation : this.mEvaluator.getAllAnnotations(owner, true)) {
            String signature = annotation.getQualifiedName();
            if (signature == null) continue;
            if (signature.equals(COLOR_INT_ANNOTATION)) {
                return EnumSet.of(COLOR_INT_MARKER_TYPE);
            }
            if (signature.equals(PX_ANNOTATION)) {
                return EnumSet.of(PX_MARKER_TYPE);
            }
            if (!signature.endsWith(RES_SUFFIX) || !signature.startsWith("android.support.annotation.")) continue;
            String typeString = signature.substring("android.support.annotation.".length(), signature.length() - RES_SUFFIX.length()).toLowerCase(Locale.US);
            ResourceType type = ResourceType.getEnum((String)typeString);
            if (type != null) {
                return EnumSet.of(type);
            }
            if (!typeString.equals("any")) continue;
            return ResourceEvaluator.getAnyRes();
        }
        return null;
    }

    public static ResourceUrl getResourceConstant(PsiElement node) {
        PsiClass rClass;
        PsiField field;
        PsiClass typeClass;
        if (node instanceof PsiReferenceExpression) {
            PsiReferenceExpression reference;
            PsiReferenceExpression select;
            PsiReferenceExpression expression = (PsiReferenceExpression)node;
            if (expression.getQualifier() instanceof PsiReferenceExpression && (select = (PsiReferenceExpression)expression.getQualifier()).getQualifier() instanceof PsiReferenceExpression && "R".equals((reference = (PsiReferenceExpression)select.getQualifier()).getReferenceName())) {
                String typeName = select.getReferenceName();
                String name = expression.getReferenceName();
                ResourceType type = ResourceType.getEnum((String)typeName);
                if (type != null && name != null) {
                    boolean isFramework = reference.getQualifier() instanceof PsiReferenceExpression && "android".equals(((PsiReferenceExpression)reference.getQualifier()).getReferenceName());
                    return ResourceUrl.create((ResourceType)type, (String)name, (boolean)isFramework, (boolean)false);
                }
            }
        } else if (node instanceof PsiField && (typeClass = (field = (PsiField)node).getContainingClass()) != null && (rClass = typeClass.getContainingClass()) != null && "R".equals(rClass.getName())) {
            String name = field.getName();
            ResourceType type = ResourceType.getEnum((String)typeClass.getName());
            if (type != null && name != null) {
                String qualifiedName = rClass.getQualifiedName();
                boolean isFramework = qualifiedName != null && qualifiedName.startsWith("android.");
                return ResourceUrl.create((ResourceType)type, (String)name, (boolean)isFramework, (boolean)false);
            }
        }
        return null;
    }

    private static EnumSet<ResourceType> getAnyRes() {
        EnumSet<ResourceType> types = EnumSet.allOf(ResourceType.class);
        types.remove(COLOR_INT_MARKER_TYPE);
        types.remove(PX_MARKER_TYPE);
        return types;
    }
}

