/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat.admin;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.oss.admin.jmx.JmxAdminException;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.tomcat.TomcatDeploymentModelBase;
import org.jetbrains.idea.tomcat.TomcatModuleDeploymentModel;
import org.jetbrains.idea.tomcat.TomcatUtil;
import org.jetbrains.idea.tomcat.admin.TomEEAgentAdminServerImpl;
import org.jetbrains.idea.tomcat.admin.TomcatAdminServerBase;
import org.jetbrains.idea.tomcat.server.TomcatRemoteModel;

public class TomcatAdminRemoteServerImpl
extends TomcatAdminServerBase<TomcatRemoteModel> {
    public TomcatAdminRemoteServerImpl(TomcatRemoteModel serverModel, TomEEAgentAdminServerImpl tomEEAdmin) {
        super(serverModel, tomEEAdmin);
    }

    @Override
    public boolean doConnectTomcat() {
        if (this.isUseJmx()) {
            return this.doConnectJmx();
        }
        return true;
    }

    @Override
    protected String prepareDeployment(TomcatDeploymentModelBase deploymentModel, String deploymentPath) throws JmxAdminException {
        try {
            TomcatRemoteModel serverModel = (TomcatRemoteModel)((Object)this.getServerModel());
            String preparedPath = serverModel.prepareDeployment(deploymentPath);
            if (serverModel.isContextDescriptorExist()) {
                File contextXml = this.addApplicationContext(deploymentModel, preparedPath);
                serverModel.transferContextFile(contextXml);
            }
            return preparedPath;
        }
        catch (RuntimeConfigurationException e) {
            throw new JmxAdminException((Exception)((Object)e));
        }
    }

    @NotNull
    public File addApplicationContext(TomcatDeploymentModelBase tomcatModuleDeploymentModel, String preparedPath) throws JmxAdminException {
        File file;
        try {
            Document xmlDocument;
            String contextPath = tomcatModuleDeploymentModel.getContextPath();
            String contextName = TomcatUtil.getContextName(contextPath);
            File contextDir = FileUtil.createTempDirectory((String)contextName, (String)"-context-xml", (boolean)true);
            Element contextElement = TomcatUtil.findContextInContextXml(tomcatModuleDeploymentModel);
            if (contextElement == null) {
                contextElement = new Element("Context");
            }
            if (!((TomcatModuleDeploymentModel)tomcatModuleDeploymentModel).isEEArtifact()) {
                contextElement.setAttribute("path", contextPath);
            }
            contextElement.setAttribute("docBase", preparedPath);
            File targetContextXmlFile = new File(contextDir, contextName + ".xml");
            if (contextElement.getDocument() != null && contextElement.isRootElement()) {
                xmlDocument = contextElement.getDocument().clone();
            } else {
                xmlDocument = new Document();
                xmlDocument.setRootElement(contextElement.clone());
            }
            TomcatUtil.saveXMLFile(xmlDocument, targetContextXmlFile, true);
            file = targetContextXmlFile;
        }
        catch (ExecutionException | IOException e) {
            throw new JmxAdminException((Exception)e);
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/tomcat/admin/TomcatAdminRemoteServerImpl", "addApplicationContext"));
        }
        return file;
    }
}

