/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.editorActions;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.freemarker.psi.files.FtlFileViewProvider;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class FreeMarkerSlashTypedHandler
extends TypedHandlerDelegate {
    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/freemarker/editorActions/FreeMarkerSlashTypedHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/freemarker/editorActions/FreeMarkerSlashTypedHandler", "charTyped"));
        }
        FileViewProvider provider = file.getViewProvider();
        if (c == '/' && provider instanceof FtlFileViewProvider) {
            ASTNode prevLeaf;
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = provider.findElementAt(offset - 1, XMLLanguage.class);
            ASTNode aSTNode = prevLeaf = element != null ? element.getNode() : null;
            if (prevLeaf != null && "</".equals(prevLeaf.getText()) && prevLeaf.getElementType() == XmlTokenType.XML_END_TAG_START) {
                return TypedHandlerDelegate.Result.DEFAULT;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }
}

