/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteSmartMacro;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.inspections.DefineInCommentIntentionBase;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.psi.directives.FtlFileReference;
import com.intellij.freemarker.psi.files.FtlFileViewProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public abstract class DefineFtlRootIntention
extends DefineInCommentIntentionBase {
    protected DefineFtlRootIntention(String text) {
        super(text);
    }

    @NotNull
    public String getFamilyName() {
        String string = FreeMarkerBundle.message("define.template.root.fix.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/DefineFtlRootIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiReference reference;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/DefineFtlRootIntention", "isAvailable"));
        }
        if (!(file.getViewProvider() instanceof FtlFileViewProvider)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        if (charSequence.length() > offset && !Character.isJavaIdentifierPart(charSequence.charAt(offset))) {
            --offset;
        }
        if (!((reference = file.findReferenceAt(offset)) instanceof PsiMultiReference)) {
            return false;
        }
        FtlFileReference fileReference = (FtlFileReference)((Object)ContainerUtil.findInstance((Object[])((PsiMultiReference)reference).getReferences(), FtlFileReference.class));
        if (fileReference == null) {
            return false;
        }
        if (!fileReference.getFileReferenceSet().isAbsolutePathReference()) {
            return false;
        }
        if (fileReference.resolve() != null) {
            return false;
        }
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        return module != null;
    }

    @Override
    protected void fillTemplate(Template template, PsiFile targetFile, PsiFile sourceFile, FtlDirectiveStyle style, Editor editor) throws IncorrectOperationException {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)targetFile.getProject());
        Document document = documentManager.getDocument(targetFile);
        assert (document != null);
        template.addTextSegment(style.getDirectiveStartChar() + "#-- @ftlroot \"");
        MacroCallNode pathExpression = new MacroCallNode((Macro)new CompleteSmartMacro());
        template.addVariable("NAME", (Expression)pathExpression, (Expression)pathExpression, true);
        template.addTextSegment("\" --" + style.getDirectiveEndChar() + "\n");
        template.addEndVariable();
    }

    public static class ModuleWide
    extends DefineFtlRootIntention {
        public ModuleWide() {
            super(FreeMarkerBundle.message("define.template.root.fix.name.module.wide", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/DefineFtlRootIntention$ModuleWide", "invoke"));
            }
            this.chooseTargetFile(file, editor);
        }
    }

    public static class Local
    extends DefineFtlRootIntention {
        public Local() {
            super(FreeMarkerBundle.message("define.template.root.fix.name.local", new Object[0]));
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/freemarker/inspections/DefineFtlRootIntention$Local", "invoke"));
            }
            this.addDeclaration(file, editor, file);
        }
    }
}

