/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlFileReference
extends FileReference {
    public FtlFileReference(TextRange range, int index, String text, FileReferenceSet set) {
        super(set, range, index, text);
    }

    @Nullable
    public PsiFileSystemItem resolveInContext(@NotNull PsiFileSystemItem context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/psi/directives/FtlFileReference", "resolveInContext"));
        }
        SmartList result = new SmartList();
        this.innerResolveInContext(this.getText(), context, (Collection<ResolveResult>)result, false);
        return result.size() > 0 ? (PsiFileSystemItem)((ResolveResult)result.get(0)).getElement() : null;
    }

    public void innerResolveInContext(final @NotNull String text, @NotNull PsiFileSystemItem context, final Collection<ResolveResult> result, boolean caseSensitive) {
        int i;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/freemarker/psi/directives/FtlFileReference", "innerResolveInContext"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/psi/directives/FtlFileReference", "innerResolveInContext"));
        }
        if (this.isLast() && (i = text.lastIndexOf(46)) > 0) {
            final String name = text.substring(0, i) + "_";
            final String extension = text.substring(i + 1);
            FtlFileReference.processVariants((PsiFileSystemItem)context, (PsiFileSystemItemProcessor)new PsiFileSystemItemProcessor(){

                public boolean acceptItem(String fileName, boolean isDirectory) {
                    if (isDirectory) {
                        return false;
                    }
                    if (text.equals(fileName)) {
                        return true;
                    }
                    return FileUtilRt.extensionEquals((String)fileName, (String)extension) && fileName.startsWith(name);
                }

                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/psi/directives/FtlFileReference$1", "execute"));
                    }
                    result.add(new PsiElementResolveResult((PsiElement)FtlFileReference.getOriginalFile((PsiFileSystemItem)element)));
                    return true;
                }
            });
            return;
        }
        super.innerResolveInContext(text, context, result, caseSensitive);
    }
}

