/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.files;

import com.intellij.freemarker.psi.directives.FtlLoopVariable;
import com.intellij.freemarker.psi.variables.FtlDynamicMember;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FtlRenameProcessor
extends RenamePsiElementProcessor {
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        if (element instanceof FtlLoopVariable) {
            FtlLoopVariable renamedVariable = (FtlLoopVariable)element;
            String rawName = renamedVariable.getName();
            for (FtlLoopVariable variable : renamedVariable.uniteWithDependents()) {
                allRenames.put((PsiElement)variable, newName + variable.getSuffix());
            }
        }
        super.prepareRenaming(element, newName, allRenames);
    }

    public PsiElement substituteElementToRename(PsiElement element, Editor editor) {
        if (element instanceof FtlDynamicMember) {
            return ((FtlDynamicMember)element).getDeclaration();
        }
        return ((FtlLoopVariable)element).getMainVariable();
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/psi/files/FtlRenameProcessor", "canProcessElement"));
        }
        return element instanceof FtlLoopVariable || element instanceof FtlDynamicMember;
    }
}

