/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.model;

import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlSchemaProvider;
import java.net.URL;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CdiBeansXmlSchemaProvider
extends XmlSchemaProvider {
    public boolean isAvailable(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/cdi/model/CdiBeansXmlSchemaProvider", "isAvailable"));
        }
        if (!"beans.xml".equals(file.getName())) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        return CdiCommonUtils.isCdiInstalled(module);
    }

    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/cdi/model/CdiBeansXmlSchemaProvider", "getSchema"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/cdi/model/CdiBeansXmlSchemaProvider", "getSchema"));
        }
        if (module == null) {
            return null;
        }
        String resourceName = CdiBeansXmlSchemaProvider.getResourceName(url);
        if (resourceName == null) {
            return null;
        }
        URL resource = CdiBeansXmlSchemaProvider.class.getResource(resourceName);
        if (resource != null) {
            VirtualFile virtualFile = VfsUtil.findFileByURL((URL)resource);
            PsiFile psiFile = baseFile.getManager().findFile(virtualFile);
            return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        }
        return null;
    }

    @Nullable
    private static String getResourceName(String url) {
        if (url.startsWith("http://xmlns.jcp.org/xml/ns/javaee")) {
            return "/resources/schemas/beans_1_1.xsd";
        }
        if (url.startsWith("http://java.sun.com/xml/ns/javaee")) {
            return "/resources/schemas/beans_1_0.xsd";
        }
        return null;
    }
}

