/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.toolWindow.tree.nodes;

import com.intellij.cdi.toolWindow.tree.CdiTreeStructure;
import com.intellij.cdi.toolWindow.tree.nodes.AbstractCdiTypeNode;
import com.intellij.cdi.toolWindow.tree.nodes.CdiTreeRootNode;
import com.intellij.cdi.toolWindow.tree.nodes.DeploymentsNode;
import com.intellij.cdi.toolWindow.tree.nodes.NamedNode;
import com.intellij.cdi.toolWindow.tree.nodes.QualifiersNode;
import com.intellij.cdi.toolWindow.tree.nodes.ScopeNode;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.Module;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.CdiCoreIcons;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CdiModuleNode
extends SimpleNode {
    private final Module myModule;
    private final CdiTreeStructure myTreeStructure;

    public CdiModuleNode(@NotNull Module module, CdiTreeStructure treeStructure, CdiTreeRootNode cdiTreeRootNode) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/toolWindow/tree/nodes/CdiModuleNode", "<init>"));
        }
        super((SimpleNode)cdiTreeRootNode);
        this.myModule = module;
        this.myTreeStructure = treeStructure;
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        if (!this.myModule.isDisposed()) {
            presentation.setIcon(CdiCoreIcons.Cdi);
            presentation.addText(this.myModule.getName(), this.getPlainAttributes());
        }
    }

    public SimpleNode[] getChildren() {
        ArrayList<SimpleNode> children = new ArrayList<SimpleNode>();
        if (!this.myModule.isDisposed()) {
            this.addIfNeeded(children, new QualifiersNode(this.myModule, this));
            this.addIfNeeded(children, new DeploymentsNode(this.myModule, this));
            this.addIfNeeded(children, new ScopeNode(this.myModule, this));
            this.addIfNeeded(children, new NamedNode(this.myModule, this));
        }
        return children.toArray(new SimpleNode[children.size()]);
    }

    private void addIfNeeded(List<SimpleNode> children, AbstractCdiTypeNode node) {
        if (this.myTreeStructure.getCdiViewSettings().isSelected(node.getType())) {
            children.add(node);
        }
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myModule};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/toolWindow/tree/nodes/CdiModuleNode", "getEqualityObjects"));
        }
        return objectArray;
    }
}

