/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.Checkin;

import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import net.sourceforge.transparent.TransparentVcs;

public class CCaseCheckinHandler
extends CheckinHandler {
    private final TransparentVcs host;
    private final CheckinProjectPanel panel;

    public CCaseCheckinHandler(TransparentVcs host, CheckinProjectPanel panel) {
        this.host = host;
        this.panel = panel;
    }

    public CheckinHandler.ReturnResult beforeCheckin() {
        int result;
        Collection files = this.panel.getVirtualFiles();
        HashSet<VirtualFile> set = new HashSet<VirtualFile>();
        for (VirtualFile file : files) {
            for (String newFolderName : this.host.renamedFolders.keySet()) {
                if (!file.getPath().startsWith(newFolderName)) continue;
                VirtualFile parent = VcsUtil.getVirtualFile((String)newFolderName);
                set.add(parent);
            }
        }
        for (VirtualFile file : files) {
            set.remove(file);
        }
        if (set.size() > 0 && (result = Messages.showOkCancelDialog((String)"Renamed folder(s) for committed file(s) will be added to the changelist", (String)"Change list is incomplete", (Icon)Messages.getWarningIcon())) != 0) {
            return CheckinHandler.ReturnResult.CANCEL;
        }
        return CheckinHandler.ReturnResult.COMMIT;
    }
}

