/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent;

import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.util.ArrayUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.transparent.TransparentVcs;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class DescribeMultipleProcessor {
    @NonNls
    private static final String DESCRIBE_COMMAND = "describe";
    @NonNls
    private static final String FMT_SWITCH = "-fmt";
    @NonNls
    private static final String FORMAT_SIG = "%Xn --> %[activity]p\n";
    @NonNls
    private static final String DELIMITER = " --> ";
    private static final int CMDLINE_MAX_LENGTH = 500;
    private final String[] files;
    private HashMap<String, String> file2Activity;

    public DescribeMultipleProcessor(List<String> paths) {
        this.files = ArrayUtil.toStringArray(paths);
    }

    public void execute() {
        this.file2Activity = new HashMap();
        int currFileIndex = 0;
        int batchStartIndex = 0;
        LinkedList<String> options = new LinkedList<String>();
        while (currFileIndex < this.files.length) {
            String path;
            options.clear();
            options.add(DESCRIBE_COMMAND);
            options.add(FMT_SWITCH);
            options.add(FORMAT_SIG);
            for (int cmdLineLen = DESCRIBE_COMMAND.length() + FMT_SWITCH.length() + FORMAT_SIG.length(); currFileIndex < this.files.length && cmdLineLen < 500; cmdLineLen += path.length() + 1) {
                path = this.files[currFileIndex++];
                options.add(path);
            }
            String[] aOptions = ArrayUtil.toStringArray(options);
            String out = TransparentVcs.cleartoolWithOutput(aOptions);
            this.parseCleartoolOutput(out, batchStartIndex);
            batchStartIndex = currFileIndex;
        }
    }

    @Nullable
    public String getActivity(String fileName) {
        return this.file2Activity.get(fileName);
    }

    private void parseCleartoolOutput(String out, int startIndex) {
        String[] lines;
        TransparentVcs.LOG.info("\n" + out);
        int shiftIndex = 0;
        for (String line : lines = LineTokenizer.tokenize((CharSequence)out, (boolean)false)) {
            int index = line.indexOf(DELIMITER);
            if (index == -1) continue;
            String activity = line.substring(index + DELIMITER.length());
            this.file2Activity.put(this.files[shiftIndex + startIndex], activity);
            ++shiftIndex;
        }
    }
}

