/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.actions.AsynchronousAction;
import org.jetbrains.annotations.NonNls;

public class VersionTreeAction
extends AsynchronousAction {
    @NonNls
    private static final String ACTION_NAME = "Version Tree";

    @Override
    public void perform(VirtualFile file, Project project) {
        VersionTreeAction.cleartool("lsvtree", "-g", VersionTreeAction.getVersionExtendedPathName(project, file));
    }

    @Override
    protected String getActionName(AnActionEvent e) {
        return ACTION_NAME;
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        TransparentVcs host = VersionTreeAction.getHost(e);
        boolean isVisible = host != null && host.getConfig() != null;
        e.getPresentation().setVisible(isVisible);
        e.getPresentation().setEnabled(isVisible && !host.getConfig().isOffline() && e.getPresentation().isEnabled());
    }

    @Override
    protected boolean isEnabled(VirtualFile file, Project project) {
        if (!VcsUtil.isFileForVcs((VirtualFile)file, (Project)project, (AbstractVcs)TransparentVcs.getInstance(project))) {
            return false;
        }
        FileStatus status = VersionTreeAction.getFileStatus(project, file);
        return status != FileStatus.ADDED && status != FileStatus.UNKNOWN && status != FileStatus.IGNORED;
    }
}

