/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.javascript.flex.css.FlexCssElementDescriptorProvider;
import com.intellij.javascript.flex.css.FlexCssUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiPolyVariantCachingReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssPropertyValueReference
extends PsiPolyVariantCachingReference
implements CssReference {
    private final PsiElement myElement;
    private final int myStart;
    private final int myEnd;

    public CssPropertyValueReference(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/css/CssPropertyValueReference", "<init>"));
        }
        this.myElement = element;
        String text = element.getText();
        if (FlexCssUtil.inQuotes(text)) {
            this.myStart = 1;
            this.myEnd = text.length() - 1;
        } else {
            this.myStart = 0;
            this.myEnd = 0;
        }
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)"invalid.css.property.name.message", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/CssPropertyValueReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    @NotNull
    protected ResolveResult[] resolveInner(boolean incompleteCode, @NotNull PsiFile containingFile) {
        FlexCssElementDescriptorProvider provider;
        CssPropertyDescriptor descriptor;
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/javascript/flex/css/CssPropertyValueReference", "resolveInner"));
        }
        String value = this.myElement.getText();
        if (FlexCssUtil.inQuotes(value) && (descriptor = (provider = (FlexCssElementDescriptorProvider)((Object)CssElementDescriptorProvider.EP_NAME.findExtension(FlexCssElementDescriptorProvider.class))).getPropertyDescriptor(value.substring(1, value.length() - 1), this.myElement)) != null) {
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])descriptor.getDeclarations(this.myElement));
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/CssPropertyValueReference", "resolveInner"));
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/CssPropertyValueReference", "resolveInner"));
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return new TextRange(this.myStart, this.myEnd);
    }

    @NotNull
    public String getCanonicalText() {
        String text = this.myElement.getText();
        if (FlexCssUtil.inQuotes(text)) {
            String string = text.substring(1, text.length() - 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/CssPropertyValueReference", "getCanonicalText"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/CssPropertyValueReference", "getCanonicalText"));
        }
        return "";
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)this.myElement);
        assert (manipulator != null);
        return manipulator.handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/css/CssPropertyValueReference", "bindToElement"));
        }
        return null;
    }

    @NotNull
    public Object[] getVariants() {
        FlexCssElementDescriptorProvider flexDescriptorProvider = (FlexCssElementDescriptorProvider)((Object)CssElementDescriptorProvider.EP_NAME.findExtension(FlexCssElementDescriptorProvider.class));
        Object[] objectArray = CssDescriptorsUtil.extractDescriptorsIdsAsArray(flexDescriptorProvider.getAllPropertyDescriptors(this.myElement));
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/css/CssPropertyValueReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isReferenceTo(PsiElement element) {
        ResolveResult[] results;
        for (ResolveResult result : results = this.multiResolve(false)) {
            if (!this.myElement.getManager().areElementsEquivalent(result.getElement(), element)) continue;
            return true;
        }
        return false;
    }

    public boolean isSoft() {
        return true;
    }
}

