/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.css;

import com.intellij.javascript.flex.css.FlexCssUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.impl.util.table.CssColorValue;
import com.intellij.xml.util.ColorMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexCssColorValue
extends CssColorValue {
    public FlexCssColorValue() {
        super(false);
    }

    private static boolean containsOnlyLetters(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (Character.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isInteger(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/javascript/flex/css/FlexCssColorValue", "isInteger"));
        }
        try {
            Integer.parseInt(s, 16);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public boolean isValueBelongs(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        String text = element.getText().trim();
        if (FlexCssColorValue.isInteger(text)) {
            return true;
        }
        if (!super.isValueBelongs(element)) {
            if (FlexCssUtil.inQuotes(text)) {
                if ((text = text.substring(1, text.length() - 1)).startsWith("0x")) {
                    return FlexCssColorValue.isInteger(text.substring(2));
                }
                if (FlexCssColorValue.containsOnlyLetters(text)) {
                    return ColorMap.isStandardColor((String)text.toLowerCase());
                }
            }
            return false;
        }
        if (FlexCssColorValue.containsOnlyLetters(text)) {
            return ColorMap.isStandardColor((String)text.toLowerCase());
        }
        return true;
    }
}

