/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.mxml;

import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassProvider;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MxmlJSClassProvider
extends XmlBackedJSClassProvider {
    @NonNls
    public static final String SCRIPT_TAG_NAME = "Script";
    private static final Key<CachedValue<XmlTag[]>> CHILD_INLINE_COMPONENTS_TAGS_KEY = Key.create((String)"child.inline.components.tags");
    private static final UserDataCache<CachedValue<XmlTag[]>, XmlTag, Object> ourChildComponentsTagsCache = new UserDataCache<CachedValue<XmlTag[]>, XmlTag, Object>(){

        protected CachedValue<XmlTag[]> compute(final XmlTag tag, Object p) {
            return CachedValuesManager.getManager((Project)tag.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<XmlTag[]>(){

                public CachedValueProvider.Result<XmlTag[]> compute() {
                    final ArrayList result = new ArrayList();
                    tag.processElements(new PsiElementProcessor(){

                        public boolean execute(@NotNull PsiElement element) {
                            if (element == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/flex/mxml/MxmlJSClassProvider$1$1$1", "execute"));
                            }
                            if (element instanceof XmlTag) {
                                XmlTag tag = (XmlTag)element;
                                if (XmlBackedJSClassImpl.isComponentTag((XmlTag)tag)) {
                                    XmlTag[] subtags = tag.getSubTags();
                                    if (subtags.length > 0) {
                                        result.add(subtags[0]);
                                    }
                                } else {
                                    tag.processElements((PsiElementProcessor)this, null);
                                }
                            }
                            return true;
                        }
                    }, null);
                    return new CachedValueProvider.Result((Object)result.toArray(new XmlTag[result.size()]), new Object[]{tag});
                }
            }, false);
        }
    };

    public static MxmlJSClassProvider getInstance() {
        for (XmlBackedJSClassProvider provider : (XmlBackedJSClassProvider[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
            if (!(provider instanceof MxmlJSClassProvider)) continue;
            return (MxmlJSClassProvider)provider;
        }
        assert (false);
        return null;
    }

    public boolean hasJSClass(XmlFile file) {
        return JavaScriptSupportLoader.isMxmlOrFxgFile((PsiFile)file);
    }

    public boolean isScriptTag(XmlTag tag) {
        return SCRIPT_TAG_NAME.equals(tag.getLocalName());
    }

    public boolean canCreateClassFromTag(XmlTag tag) {
        return MxmlJSClassProvider.isComponentSubTag(tag);
    }

    public XmlTag getClassOwnerTag(XmlTag tag) {
        if (MxmlJSClassProvider.isComponentSubTag(tag)) {
            return tag.getParentTag().getSubTags()[0];
        }
        return tag;
    }

    public XmlBackedJSClass createClassFromTag(XmlTag tag) {
        XmlFile file = (XmlFile)tag.getContainingFile();
        if (file.getRootTag() == tag && JavaScriptSupportLoader.isMxmlOrFxgFile((PsiFile)file)) {
            return new MxmlJSClass(tag);
        }
        if (MxmlJSClassProvider.isComponentSubTag(tag)) {
            return new MxmlJSClass(tag.getParentTag().getSubTags()[0]);
        }
        return null;
    }

    private static boolean isComponentSubTag(XmlTag tag) {
        XmlTag parentTag = tag.getParentTag();
        return parentTag != null && XmlBackedJSClassImpl.isComponentTag((XmlTag)parentTag);
    }

    public Collection<? extends JSClass> getChildClasses(XmlFile file) {
        return MxmlJSClassProvider.getChildInlineComponents(file.getRootTag(), true);
    }

    private static void collectComponentsTagRecursively(XmlTag[] parents, Collection<XmlTag> result) {
        ContainerUtil.addAll(result, (Object[])parents);
        for (XmlTag parent : parents) {
            MxmlJSClassProvider.collectComponentsTagRecursively((XmlTag[])((CachedValue)ourChildComponentsTagsCache.get(CHILD_INLINE_COMPONENTS_TAGS_KEY, (UserDataHolder)parent, null)).getValue(), result);
        }
    }

    public static Collection<XmlBackedJSClass> getChildInlineComponents(XmlTag rootTag, boolean recursive) {
        List<XmlTag> allChildren;
        XmlTag[] directChildren = (XmlTag[])((CachedValue)ourChildComponentsTagsCache.get(CHILD_INLINE_COMPONENTS_TAGS_KEY, (UserDataHolder)rootTag, null)).getValue();
        if (recursive) {
            allChildren = new ArrayList<XmlTag>();
            MxmlJSClassProvider.collectComponentsTagRecursively(directChildren, allChildren);
        } else {
            allChildren = Arrays.asList(directChildren);
        }
        ArrayList<XmlBackedJSClass> result = new ArrayList<XmlBackedJSClass>(allChildren.size());
        for (XmlTag tag : allChildren) {
            result.add(XmlBackedJSClassFactory.getInstance().getXmlBackedClass(tag));
        }
        return result;
    }
}

