/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.flex.refactoring.moveClass;

import com.intellij.javascript.flex.resolve.ActionScriptClassResolver;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringConflictsUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.CreateClassOrInterfaceFix;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexMoveInnerClassProcessor
extends BaseRefactoringProcessor {
    private final JSQualifiedNamedElement myElement;
    private final PsiDirectory myTargetDirectory;
    private final String myClassName;
    private final String myPackageName;
    private final boolean mySearchInComments;
    private final boolean mySearchTextOccurences;
    @Nullable
    private final MoveCallback myMoveCallback;
    private NonCodeUsageInfo[] myNonCodeUsages;

    public FlexMoveInnerClassProcessor(JSQualifiedNamedElement element, PsiDirectory targetDirectory, String className, String packageName, boolean searchInComments, boolean searchTextOccurences, @Nullable MoveCallback moveCallback) {
        super(element.getProject());
        this.myElement = element;
        this.myTargetDirectory = targetDirectory;
        this.myClassName = className;
        this.myPackageName = packageName;
        this.mySearchInComments = searchInComments;
        this.mySearchTextOccurences = searchTextOccurences;
        this.myMoveCallback = moveCallback;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/javascript/flex/refactoring/moveClass/FlexMoveInnerClassProcessor", "createUsageViewDescriptor"));
        }
        FlexMoveInnerClassUsageViewDescriptor flexMoveInnerClassUsageViewDescriptor = new FlexMoveInnerClassUsageViewDescriptor();
        if (flexMoveInnerClassUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/refactoring/moveClass/FlexMoveInnerClassProcessor", "createUsageViewDescriptor"));
        }
        return flexMoveInnerClassUsageViewDescriptor;
    }

    @NotNull
    protected UsageInfo[] findUsages() {
        JSFunction constructor;
        Collection<UsageInfo> result = Collections.synchronizedCollection(new ArrayList());
        ReferencesSearch.search((PsiElement)this.myElement, (SearchScope)new LocalSearchScope((PsiElement)this.myElement.getContainingFile())).forEach(reference -> {
            PsiElement element = reference.getElement();
            if (!(element instanceof JSReferenceExpression)) {
                return true;
            }
            if (JSResolveUtil.isSelfReference((PsiElement)element)) {
                return true;
            }
            result.add(new UsageInfo(element));
            return true;
        });
        if (this.myElement instanceof JSClass && (constructor = ((JSClass)this.myElement).getConstructor()) != null) {
            result.add(new UsageInfo((PsiElement)constructor));
            JSRefactoringUtil.addConstructorUsages((JSClass)((JSClass)this.myElement), result);
        }
        TextOccurrencesUtil.findNonCodeUsages((PsiElement)this.myElement, (String)this.myElement.getName(), (boolean)this.mySearchInComments, (boolean)this.mySearchTextOccurences, (String)StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassName), result);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])result.toArray(new UsageInfo[result.size()]));
        if (usageInfoArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/flex/refactoring/moveClass/FlexMoveInnerClassProcessor", "findUsages"));
        }
        return usageInfoArray;
    }

    protected void performRefactoring(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/javascript/flex/refactoring/moveClass/FlexMoveInnerClassProcessor", "performRefactoring"));
        }
        try {
            CreateClassOrInterfaceFix.createClass((String)this.myClassName, (String)this.myPackageName, (PsiDirectory)this.myTargetDirectory, (boolean)false);
        }
        catch (Exception e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)this.getCommandName());
            return;
        }
        PsiFile sourceFile = this.myElement.getContainingFile();
        HashSet importsInTargetFile = new HashSet();
        HashSet namespacesInTargetFile = new HashSet();
        ArrayList formatters = new ArrayList();
        JSClass targetClass = this.myElement instanceof JSClass ? (JSClass)this.myElement : null;
        JSRefactoringUtil.fixOutgoingReferences((PsiElement)this.myElement, importsInTargetFile, namespacesInTargetFile, Collections.singletonList((JSAttributeListOwner)this.myElement), (JSClass)targetClass, (boolean)false, (boolean)false);
        this.myElement.setName(this.myClassName);
        ArrayList<UsageInfo> usagesToProcess = new ArrayList<UsageInfo>(Arrays.asList(usages));
        Iterator i = usagesToProcess.iterator();
        while (i.hasNext()) {
            PsiElement element;
            UsageInfo usage = (UsageInfo)i.next();
            if (usage instanceof NonCodeUsageInfo || (element = usage.getElement()) == null || !PsiTreeUtil.isAncestor((PsiElement)this.myElement, (PsiElement)element, (boolean)false)) continue;
            if (element instanceof JSReferenceExpression) {
                ((JSReferenceExpression)element).bindToElement((PsiElement)this.myElement);
            } else {
                if (!(element instanceof PsiNamedElement)) continue;
                ((PsiNamedElement)element).setName(this.myClassName);
            }
            i.remove();
        }
        PsiElement clazz = ActionScriptClassResolver.findClassByQNameStatic(StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassName), GlobalSearchScope.projectScope((Project)this.myProject));
        PsiElement toInsert = this.myElement instanceof JSVariable ? JSRefactoringUtil.getVarStatementCopy((JSVariable)((JSVariable)this.myElement)) : this.myElement.copy();
        PsiElement inserted = clazz.replace(toInsert);
        PsiFile insertedContainingFile = inserted.getContainingFile();
        JSQualifiedNamedElement newClass = inserted instanceof JSVarStatement ? ((JSVarStatement)inserted).getVariables()[0] : (JSQualifiedNamedElement)inserted;
        SmartPsiElementPointer newClassPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)newClass);
        JSRefactoringUtil.handleDocCommentAndFormat((PsiElement)inserted, formatters);
        JSRefactoringUtil.deleteWithNoPostponedFormatting((PsiElement)this.myElement);
        if (this.myPackageName.length() > 0) {
            for (UsageInfo usage : usagesToProcess) {
                Object element;
                if (usage instanceof NonCodeUsageInfo || usage.getFile() != sourceFile || (element = usage.getElement()) == null) continue;
                ImportUtils.doImport((PsiElement)element, (String)StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassName), (boolean)true);
            }
        }
        JSRefactoringUtil.postProcess((PsiElement)sourceFile, (JSQualifiedNamedElement)newClass, Collections.singletonList(sourceFile), importsInTargetFile, namespacesInTargetFile, formatters, (boolean)true, (boolean)false);
        boolean makePublic = false;
        newClass = (JSQualifiedNamedElement)newClassPointer.getElement();
        ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
        for (UsageInfo usage : usagesToProcess) {
            if (usage instanceof NonCodeUsageInfo) {
                nonCodeUsages.add((NonCodeUsageInfo)usage);
                continue;
            }
            JSReferenceExpression refExpr = (JSReferenceExpression)usage.getElement();
            if (refExpr == null) continue;
            makePublic |= JSPsiImplUtils.getQNameForMove((PsiElement)refExpr, (PsiElement)newClass) != null;
            refExpr.bindToElement((PsiElement)newClass);
        }
        JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)((JSAttributeListOwner)newClass), (JSAttributeList.AccessType)(makePublic ? JSAttributeList.AccessType.PUBLIC : JSAttributeList.AccessType.PACKAGE_LOCAL));
        this.myNonCodeUsages = nonCodeUsages.toArray(new NonCodeUsageInfo[nonCodeUsages.size()]);
        if (this.myMoveCallback != null) {
            this.myMoveCallback.refactoringCompleted();
        }
        OpenFileDescriptor descriptor = new OpenFileDescriptor(this.myProject, insertedContainingFile.getVirtualFile(), newClass.getTextOffset());
        FileEditorManager.getInstance((Project)this.myProject).openTextEditor(descriptor, true);
    }

    protected String getCommandName() {
        return FlexBundle.message("move.to.upper.level.command.name", StringUtil.decapitalize((String)JSBundle.message((String)JSNamedElementKind.kind((PsiElement)this.myElement).humanReadableKey(), (Object[])new Object[0])), this.myElement.getName(), StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassName));
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refUsages", "com/intellij/javascript/flex/refactoring/moveClass/FlexMoveInnerClassProcessor", "preprocessUsages"));
        }
        return this.showConflicts(this.detectConflicts(), (UsageInfo[])refUsages.get());
    }

    private MultiMap<PsiElement, String> detectConflicts() {
        MultiMap result = new MultiMap();
        JSVisibilityUtil.Options options = new JSVisibilityUtil.Options();
        options.overridePackage((PsiElement)this.myElement, this.myPackageName);
        JSRefactoringConflictsUtil.checkOutgoingReferencesAccessibility((PsiElement)this.myElement, Collections.singletonList(this.myElement), null, (boolean)true, (MultiMap)result, (Condition)Conditions.alwaysTrue(), (JSVisibilityUtil.Options)options);
        return result;
    }

    protected boolean isPreviewUsages(@NotNull UsageInfo[] usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/javascript/flex/refactoring/moveClass/FlexMoveInnerClassProcessor", "isPreviewUsages"));
        }
        if (UsageViewUtil.reportNonRegularUsages((UsageInfo[])usages, (Project)this.myProject)) {
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages != null) {
            RenameUtil.renameNonCodeUsages((Project)this.myProject, (NonCodeUsageInfo[])this.myNonCodeUsages);
        }
    }

    private class FlexMoveInnerClassUsageViewDescriptor
    extends BaseUsageViewDescriptor {
        public FlexMoveInnerClassUsageViewDescriptor() {
            super(new PsiElement[]{FlexMoveInnerClassProcessor.this.myElement});
        }

        public String getProcessedElementsHeader() {
            return FlexBundle.message("element.to.be.moved.to.upper.level", StringUtil.decapitalize((String)JSBundle.message((String)JSNamedElementKind.kind((PsiElement)FlexMoveInnerClassProcessor.this.myElement).humanReadableKey(), (Object[])new Object[0])), StringUtil.getQualifiedName((String)FlexMoveInnerClassProcessor.this.myPackageName, (String)FlexMoveInnerClassProcessor.this.myClassName));
        }

        public String getCodeReferencesText(int usagesCount, int filesCount) {
            return FlexBundle.message("references.in.code.to.inner.0", UsageViewUtil.getLongName((PsiElement)this.getElements()[0])) + UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount);
        }

        public String getCommentReferencesText(int usagesCount, int filesCount) {
            return RefactoringBundle.message((String)"comments.elements.header", (Object[])new Object[]{UsageViewBundle.getOccurencesString((int)usagesCount, (int)filesCount)});
        }
    }
}

