/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.artifacts;

import com.intellij.flex.model.bc.OutputType;
import com.intellij.flex.model.bc.TargetPlatform;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.artifacts.FlashBCOutputSourceItem;
import com.intellij.lang.javascript.flex.artifacts.FlashModuleSourceItem;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.FlexProjectConfigurationEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlashPackagingSourceItemsProvider
extends PackagingSourceItemsProvider {
    @NotNull
    public Collection<? extends PackagingSourceItem> getSourceItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, @Nullable PackagingSourceItem parent) {
        if (editorContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorContext", "com/intellij/lang/javascript/flex/artifacts/FlashPackagingSourceItemsProvider", "getSourceItems"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/lang/javascript/flex/artifacts/FlashPackagingSourceItemsProvider", "getSourceItems"));
        }
        if (parent == null) {
            Collection<? extends PackagingSourceItem> collection = FlashPackagingSourceItemsProvider.createFlashModuleSourceItems(editorContext);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/artifacts/FlashPackagingSourceItemsProvider", "getSourceItems"));
            }
            return collection;
        }
        if (parent instanceof FlashModuleSourceItem) {
            Collection<? extends PackagingSourceItem> collection = FlashPackagingSourceItemsProvider.createFlashBCOutputSourceItems(((FlashModuleSourceItem)parent).getModule());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/artifacts/FlashPackagingSourceItemsProvider", "getSourceItems"));
            }
            return collection;
        }
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/artifacts/FlashPackagingSourceItemsProvider", "getSourceItems"));
        }
        return list;
    }

    private static Collection<? extends PackagingSourceItem> createFlashModuleSourceItems(ArtifactEditorContext editorContext) {
        ArrayList<FlashModuleSourceItem> result = new ArrayList<FlashModuleSourceItem>();
        for (Module module : editorContext.getModulesProvider().getModules()) {
            if (ModuleType.get((Module)module) != FlexModuleType.getInstance()) continue;
            result.add(new FlashModuleSourceItem(module));
        }
        return result;
    }

    private static Collection<? extends PackagingSourceItem> createFlashBCOutputSourceItems(Module module) {
        ArrayList<FlashBCOutputSourceItem> result = new ArrayList<FlashBCOutputSourceItem>();
        int orderNumber = 0;
        FlexProjectConfigurationEditor configEditor = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getConfigEditor();
        assert (configEditor != null);
        for (ModifiableFlexBuildConfiguration bc : configEditor.getConfigurations(module)) {
            String outputFilePath = bc.getActualOutputFilePath().toLowerCase();
            if (!outputFilePath.endsWith(".swf") && !outputFilePath.endsWith(".swc")) continue;
            result.add(new FlashBCOutputSourceItem(bc, FlashBCOutputSourceItem.Type.OutputFile, orderNumber++));
            if (bc.getOutputType() == OutputType.Application && bc.getTargetPlatform() == TargetPlatform.Web && bc.isUseHtmlWrapper()) {
                result.add(new FlashBCOutputSourceItem(bc, FlashBCOutputSourceItem.Type.OutputFileAndHtmlWrapper, orderNumber++));
            }
            result.add(new FlashBCOutputSourceItem(bc, FlashBCOutputSourceItem.Type.OutputFolderContents, orderNumber++));
        }
        return result;
    }
}

