/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.build;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.build.FlashProjectStructureProblem;
import com.intellij.lang.javascript.flex.projectStructure.FlexBuildConfigurationsExtension;
import com.intellij.lang.javascript.flex.projectStructure.model.FlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.options.BCUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class FlashProjectStructureErrorsDialog
extends DialogWrapper {
    private JPanel myMainPanel;
    private Tree myTree;
    private final Project myProject;

    public FlashProjectStructureErrorsDialog(Project project, Collection<Trinity<Module, FlexBuildConfiguration, FlashProjectStructureProblem>> problems) {
        super(project);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myTree.setRootVisible(false);
        this.myTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        for (Trinity<Module, FlexBuildConfiguration, FlashProjectStructureProblem> problem : problems) {
            this.addProblem((Module)problem.first, (FlexBuildConfiguration)problem.second, (FlashProjectStructureProblem)problem.third);
        }
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
                Object userObject = treeNode.getUserObject();
                if (userObject instanceof Module) {
                    this.setIcon(ModuleType.get((Module)((Module)userObject)).getIcon());
                    this.append(((Module)userObject).getName());
                } else if (userObject instanceof FlexBuildConfiguration) {
                    this.setIcon(((FlexBuildConfiguration)userObject).getIcon());
                    BCUtils.renderBuildConfiguration((FlexBuildConfiguration)userObject, null).appendToComponent((ColoredTextContainer)this);
                } else if (userObject instanceof FlashProjectStructureProblem) {
                    this.setIcon(AllIcons.General.Error);
                    this.append(((FlashProjectStructureProblem)userObject).errorMessage);
                }
            }
        });
        this.myTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FlashProjectStructureErrorsDialog.this.openProjectStructure();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                FlashProjectStructureErrorsDialog.this.openProjectStructure();
                return true;
            }
        }.installOn((Component)this.myTree);
        this.setTitle(FlexBundle.message("project.setup.problem.title", new Object[0]));
        this.setOKButtonText(FlexBundle.message("open.project.structure", new Object[0]));
        this.init();
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        TreeUtil.expandAll((JTree)this.myTree);
        return this.myTree;
    }

    private void addProblem(Module module, FlexBuildConfiguration bc, FlashProjectStructureProblem problem) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.myTree.getModel().getRoot();
        DefaultMutableTreeNode moduleNode = FlashProjectStructureErrorsDialog.getOrCreateChildNode(rootNode, module);
        DefaultMutableTreeNode bcNode = FlashProjectStructureErrorsDialog.getOrCreateChildNode(moduleNode, bc);
        bcNode.add(new DefaultMutableTreeNode(problem));
    }

    @NotNull
    private static DefaultMutableTreeNode getOrCreateChildNode(DefaultMutableTreeNode parentNode, Object userObject) {
        DefaultMutableTreeNode childNode;
        Enumeration<TreeNode> children = parentNode.children();
        while (children.hasMoreElements()) {
            childNode = (DefaultMutableTreeNode)children.nextElement();
            if (!userObject.equals(childNode.getUserObject())) continue;
            DefaultMutableTreeNode defaultMutableTreeNode = childNode;
            if (defaultMutableTreeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/build/FlashProjectStructureErrorsDialog", "getOrCreateChildNode"));
            }
            return defaultMutableTreeNode;
        }
        childNode = new DefaultMutableTreeNode(userObject);
        parentNode.add(childNode);
        DefaultMutableTreeNode defaultMutableTreeNode = childNode;
        if (defaultMutableTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/build/FlashProjectStructureErrorsDialog", "getOrCreateChildNode"));
        }
        return defaultMutableTreeNode;
    }

    private void openProjectStructure() {
        Object userObject;
        TreePath selectionPath = this.myTree.getSelectionPath();
        DefaultMutableTreeNode node = selectionPath == null ? null : (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        Object object = userObject = node == null ? null : node.getUserObject();
        if (userObject == null) {
            return;
        }
        Ref moduleRef = new Ref();
        Ref bcRef = new Ref();
        Ref problemRef = new Ref();
        if (userObject instanceof FlashProjectStructureProblem) {
            problemRef.set((Object)((FlashProjectStructureProblem)userObject));
            node = (DefaultMutableTreeNode)node.getParent();
            userObject = node.getUserObject();
        }
        if (userObject instanceof FlexBuildConfiguration) {
            bcRef.set((Object)((FlexBuildConfiguration)userObject));
            node = (DefaultMutableTreeNode)node.getParent();
            userObject = node.getUserObject();
        }
        if (userObject instanceof Module) {
            moduleRef.set((Object)((Module)userObject));
        }
        this.close(1);
        ProjectStructureConfigurable configurable = ProjectStructureConfigurable.getInstance((Project)this.myProject);
        ShowSettingsUtil.getInstance().editConfigurable(this.myProject, (Configurable)configurable, () -> {
            Place place;
            if (problemRef.get() instanceof FlashProjectStructureProblem.FlexUnitOutputFolderProblem) {
                place = new Place().putPath("category", (Object)configurable.getProjectConfig());
            } else if (moduleRef.isNull()) {
                place = new Place().putPath("category", (Object)configurable.getModulesConfig());
            } else if (bcRef.isNull()) {
                place = new Place().putPath("category", (Object)configurable.getModulesConfig()).putPath("treeObject", moduleRef.get());
            } else {
                place = FlexBuildConfigurationsExtension.getInstance().getConfigurator().getPlaceFor((Module)moduleRef.get(), ((FlexBuildConfiguration)bcRef.get()).getName());
                if (!problemRef.isNull()) {
                    place.putPath("tabName", (Object)((FlashProjectStructureProblem)problemRef.get()).tabName);
                    place.putPath("FlashBuildConfiguration.locationOnTab", ((FlashProjectStructureProblem)problemRef.get()).locationOnTab);
                }
            }
            configurable.navigateTo(place, true);
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        Tree tree;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(600, -1), null));
        this.myTree = tree = new Tree();
        jBScrollPane.setViewportView((Component)tree);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

