/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingMode;
import com.intellij.lang.javascript.flex.debug.CommandOutputProcessingType;
import com.intellij.lang.javascript.flex.debug.FlexDebugProcess;
import com.intellij.lang.javascript.flex.debug.VMState;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class DebuggerCommand {
    private final String myText;
    private final CommandOutputProcessingType myOutputProcessingType;
    private final VMState myEndVMState;
    private final VMState myStartVMState;

    DebuggerCommand(@NotNull @NonNls String _text) {
        if (_text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_text", "com/intellij/lang/javascript/flex/debug/DebuggerCommand", "<init>"));
        }
        this(_text, CommandOutputProcessingType.NO_PROCESSING);
    }

    DebuggerCommand(@NotNull @NonNls String _text, CommandOutputProcessingType outputProcessingType) {
        if (_text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_text", "com/intellij/lang/javascript/flex/debug/DebuggerCommand", "<init>"));
        }
        this(_text, outputProcessingType, VMState.SUSPENDED, VMState.SUSPENDED);
    }

    DebuggerCommand(@NotNull @NonNls String _text, CommandOutputProcessingType outputProcessingType, VMState startState, VMState endState) {
        if (_text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_text", "com/intellij/lang/javascript/flex/debug/DebuggerCommand", "<init>"));
        }
        this.myText = _text;
        this.myOutputProcessingType = outputProcessingType;
        this.myStartVMState = startState;
        this.myEndVMState = endState;
    }

    @NotNull
    @NonNls
    String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/debug/DebuggerCommand", "getText"));
        }
        return string;
    }

    public CommandOutputProcessingType getOutputProcessingMode() {
        return this.myOutputProcessingType;
    }

    public VMState getEndVMState() {
        return this.myEndVMState;
    }

    public VMState getStartVMState() {
        return this.myStartVMState;
    }

    CommandOutputProcessingMode onTextAvailable(@NonNls String s) {
        assert (this.myOutputProcessingType != CommandOutputProcessingType.NO_PROCESSING);
        return CommandOutputProcessingMode.DONE;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void post(FlexDebugProcess flexDebugProcess) throws IOException {
        flexDebugProcess.doSendCommandText(this);
    }

    public String read(FlexDebugProcess flexDebugProcess) throws IOException {
        return flexDebugProcess.defaultReadCommand(this);
    }
}

