/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.debug;

import com.intellij.javascript.flex.mxml.MxmlJSClass;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class NodeClassInfo {
    public final String myFqn;
    public final boolean myIsDynamic;
    public final Map<String, Icon> myOwnStaticFields;
    public final Map<String, Icon> myOwnStaticProperties;
    public final Map<String, Icon> myOwnFields;
    public final Map<String, Icon> myOwnProperties;
    public final Map<String, Icon> myInheritedStaticFields;
    public final Map<String, Icon> myInheritedStaticProperties;
    public final Map<String, Icon> myInheritedFields;
    public final Map<String, Icon> myInheritedProperties;

    public NodeClassInfo(String fqn, boolean dynamic, Map<String, Icon> ownStaticFields, Map<String, Icon> ownStaticProperties, Map<String, Icon> ownFields, Map<String, Icon> ownProperties, Map<String, Icon> inheritedStaticFields, Map<String, Icon> inheritedStaticProperties, Map<String, Icon> inheritedFields, Map<String, Icon> inheritedProperties) {
        this.myFqn = fqn;
        this.myIsDynamic = dynamic;
        this.myOwnStaticFields = ownStaticFields;
        this.myOwnStaticProperties = ownStaticProperties;
        this.myOwnFields = ownFields;
        this.myOwnProperties = ownProperties;
        this.myInheritedStaticFields = inheritedStaticFields;
        this.myInheritedStaticProperties = inheritedStaticProperties;
        this.myInheritedFields = inheritedFields;
        this.myInheritedProperties = inheritedProperties;
    }

    static NodeClassInfo getNodeClassInfo(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsClass", "com/intellij/lang/javascript/flex/debug/NodeClassInfo", "getNodeClassInfo"));
        }
        JSAttributeList classAttributes = jsClass.getAttributeList();
        boolean dynamic = classAttributes != null && classAttributes.hasModifier(JSAttributeList.ModifierType.DYNAMIC);
        THashMap ownStaticFields = new THashMap();
        THashMap ownStaticProperties = new THashMap();
        THashMap ownFields = new THashMap();
        THashMap ownProperties = new THashMap();
        THashMap inheritedStaticFields = new THashMap();
        THashMap inheritedStaticProperties = new THashMap();
        THashMap inheritedFields = new THashMap();
        THashMap inheritedProperties = new THashMap();
        NodeClassInfo.fillMapsForClass(jsClass, (Map<String, Icon>)ownStaticFields, (Map<String, Icon>)ownStaticProperties, (Map<String, Icon>)ownFields, (Map<String, Icon>)ownProperties);
        NodeClassInfo.fillMapsForSupersRecursively(jsClass, (THashSet<JSClass>)new THashSet(), (Map<String, Icon>)inheritedStaticFields, (Map<String, Icon>)inheritedStaticProperties, (Map<String, Icon>)inheritedFields, (Map<String, Icon>)inheritedProperties);
        return new NodeClassInfo(NodeClassInfo.normalizeIfVector(jsClass.getQualifiedName()), dynamic, (Map<String, Icon>)ownStaticFields, (Map<String, Icon>)ownStaticProperties, (Map<String, Icon>)ownFields, (Map<String, Icon>)ownProperties, (Map<String, Icon>)inheritedStaticFields, (Map<String, Icon>)inheritedStaticProperties, (Map<String, Icon>)inheritedFields, (Map<String, Icon>)inheritedProperties);
    }

    private static String normalizeIfVector(String qName) {
        return qName.startsWith("Vector$") ? "Vector" : qName;
    }

    private static void fillMapsForSupersRecursively(JSClass jsClass, THashSet<JSClass> visited, Map<String, Icon> inheritedStaticFields, Map<String, Icon> inheritedStaticProperties, Map<String, Icon> inheritedFields, Map<String, Icon> inheritedProperties) {
        if (visited.contains((Object)jsClass)) {
            return;
        }
        visited.add((Object)jsClass);
        for (JSClass superClass : jsClass.getSuperClasses()) {
            NodeClassInfo.fillMapsForClass(superClass, inheritedStaticFields, inheritedStaticProperties, inheritedFields, inheritedProperties);
            NodeClassInfo.fillMapsForSupersRecursively(superClass, visited, inheritedStaticFields, inheritedStaticProperties, inheritedFields, inheritedProperties);
        }
    }

    private static void fillMapsForClass(JSClass jsClass, Map<String, Icon> staticFields, Map<String, Icon> staticProperties, Map<String, Icon> fields, Map<String, Icon> properties) {
        for (JSField jSField : jsClass.getFields()) {
            JSAttributeList varAttributes = jSField.getAttributeList();
            if (varAttributes != null && varAttributes.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                staticFields.put(jSField.getName(), jSField.getIcon(1));
                continue;
            }
            fields.put(jSField.getName(), jSField.getIcon(1));
        }
        for (JSField jSField : jsClass.getFunctions()) {
            if (jSField.getKind() != JSFunction.FunctionKind.GETTER || jSField.getName() == null) continue;
            JSAttributeList functionAttributes = jSField.getAttributeList();
            if (functionAttributes != null && functionAttributes.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                staticProperties.put(jSField.getName(), jSField.getIcon(1));
                continue;
            }
            properties.put(jSField.getName(), jSField.getIcon(1));
        }
        if (jsClass instanceof MxmlJSClass) {
            XmlTag rootTag;
            PsiFile file = jsClass.getContainingFile();
            XmlFile xmlFile = file instanceof XmlFile ? (XmlFile)file : null;
            XmlTag xmlTag = rootTag = xmlFile == null ? null : xmlFile.getRootTag();
            if (rootTag != null) {
                NodeClassInfo.processSubtagsRecursively(rootTag, (Processor<XmlTag>)((Processor)tag -> {
                    String id = tag.getAttributeValue("id");
                    if (id != null) {
                        fields.put(id, tag.getIcon(1));
                    }
                    return !MxmlJSClass.isTagThatAllowsAnyXmlContent(tag);
                }));
            }
        }
    }

    public static void processSubtagsRecursively(XmlTag tag, Processor<XmlTag> processor) {
        for (XmlTag subTag : tag.getSubTags()) {
            if (!processor.process((Object)subTag)) continue;
            NodeClassInfo.processSubtagsRecursively(subTag, processor);
        }
    }
}

