/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flashbuilder;

import com.intellij.CommonBundle;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderImporter;
import com.intellij.lang.javascript.flex.flashbuilder.FlashBuilderProjectFinder;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectFormatPanel;
import com.intellij.projectImport.ProjectImportWizardStep;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PathUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SelectDirWithFlashBuilderProjectsStep
extends ProjectImportWizardStep {
    private JPanel myMainPanel;
    private LabeledComponent<TextFieldWithBrowseButton> myInitialPathComponent;
    private LabeledComponent<TextFieldWithBrowseButton> myExtractPathComponent;
    private LabeledComponent<JTextField> myProjectNameComponent;
    private LabeledComponent<TextFieldWithBrowseButton> myProjectLocationComponent;
    private JLabel myMultiProjectNote;
    private JCheckBox myCreateSubfolderCheckBox;
    private ProjectFormatPanel myProjectFormatPanel;

    public SelectDirWithFlashBuilderProjectsStep(WizardContext context) {
        super(context);
        this.$$$setupUI$$$();
        this.setupInitialPathComponent();
        this.myExtractPathComponent.setVisible(false);
        ((TextFieldWithBrowseButton)this.myExtractPathComponent.getComponent()).addBrowseFolderListener(null, null, context.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor());
        boolean creatingNewProject = context.isCreatingNewProject();
        this.myProjectNameComponent.setVisible(creatingNewProject);
        this.myProjectLocationComponent.setVisible(creatingNewProject);
        ((TextFieldWithBrowseButton)this.myProjectLocationComponent.getComponent()).addBrowseFolderListener(null, null, context.getProject(), FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myProjectFormatPanel.getPanel().setVisible(creatingNewProject);
        this.myMultiProjectNote.setVisible(false);
        this.myCreateSubfolderCheckBox.setVisible(false);
    }

    private void setupInitialPathComponent() {
        ((TextFieldWithBrowseButton)this.myInitialPathComponent.getComponent()).getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                SelectDirWithFlashBuilderProjectsStep.this.onInitialPathChanged();
            }
        });
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, true, true, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && (file.isDirectory() || FlashBuilderProjectFinder.isFlashBuilderProject(file)) || FlashBuilderProjectFinder.hasArchiveExtension(file.getPath());
            }

            public Icon getIcon(VirtualFile file) {
                return !file.isDirectory() && (FlashBuilderProjectFinder.hasFxpExtension(file.getPath()) || FlashBuilderProjectFinder.isFlashBuilderProject(file)) ? 2.dressIcon((VirtualFile)file, (Icon)SelectDirWithFlashBuilderProjectsStep.this.getBuilder().getIcon()) : super.getIcon(file);
            }
        };
        ((TextFieldWithBrowseButton)this.myInitialPathComponent.getComponent()).addBrowseFolderListener(FlexBundle.message("select.flash.builder.workspace.or.project", new Object[0]), null, this.getWizardContext().getProject(), descriptor);
    }

    private void onInitialPathChanged() {
        boolean multiProjectArchive;
        String path = ((TextFieldWithBrowseButton)this.myInitialPathComponent.getComponent()).getText().trim();
        ((FlashBuilderImporter)this.getBuilder()).setInitiallySelectedPath(path);
        this.getWizardContext().requestWizardButtonsUpdate();
        VirtualFile file = path.isEmpty() ? null : LocalFileSystem.getInstance().findFileByPath(path);
        boolean isArchive = file != null && !file.isDirectory() && FlashBuilderProjectFinder.hasArchiveExtension(file.getPath());
        boolean bl = multiProjectArchive = isArchive && FlashBuilderProjectFinder.isMultiProjectArchive(file.getPath());
        if (this.getWizardContext().isCreatingNewProject()) {
            if (file != null) {
                String suggestedProjectName = ((FlashBuilderImporter)this.getBuilder()).getSuggestedProjectName();
                ((JTextField)this.myProjectNameComponent.getComponent()).setText(suggestedProjectName);
                if (isArchive) {
                    this.myProjectLocationComponent.setText(FlexBundle.message("project.location", new Object[0]));
                    String dir = this.getWizardContext().getProjectFileDirectory();
                    if (new File(dir).isFile()) {
                        dir = PathUtil.getParentPath((String)dir);
                    }
                    ((TextFieldWithBrowseButton)this.myProjectLocationComponent.getComponent()).setText(FileUtil.toSystemDependentName((String)(dir + "/" + suggestedProjectName)));
                } else {
                    this.myProjectLocationComponent.setText(FlexBundle.message("project.files.location", new Object[0]));
                    ((TextFieldWithBrowseButton)this.myProjectLocationComponent.getComponent()).setText(FileUtil.toSystemDependentName((String)(file.isDirectory() ? file.getPath() : file.getParent().getPath())));
                }
            }
            this.myMultiProjectNote.setVisible(isArchive && multiProjectArchive);
            this.myCreateSubfolderCheckBox.setVisible(isArchive && !multiProjectArchive);
            this.myCreateSubfolderCheckBox.setText(FlexBundle.message("extract.single.to.subfolder.0", file == null ? "" : file.getNameWithoutExtension()));
        } else {
            this.myExtractPathComponent.setVisible(isArchive);
            if (isArchive) {
                this.myExtractPathComponent.setText(multiProjectArchive ? FlexBundle.message("folder.to.unzip.several.FB.projects", new Object[0]) : FlexBundle.message("folder.to.unzip.one.FB.project", new Object[0]));
                String extractPath = multiProjectArchive ? this.getWizardContext().getProject().getBaseDir().getPath() : this.getWizardContext().getProject().getBaseDir().getPath() + "/" + file.getNameWithoutExtension();
                ((TextFieldWithBrowseButton)this.myExtractPathComponent.getComponent()).setText(FileUtil.toSystemDependentName((String)extractPath));
            }
        }
    }

    private void createUIComponents() {
        this.myProjectFormatPanel = new ProjectFormatPanel();
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return ((TextFieldWithBrowseButton)this.myInitialPathComponent.getComponent()).getTextField();
    }

    public void updateStep() {
        if (this.getWizardContext().isProjectFileDirectorySet() && ((TextFieldWithBrowseButton)this.myInitialPathComponent.getComponent()).getText().isEmpty()) {
            ((TextFieldWithBrowseButton)this.myInitialPathComponent.getComponent()).setText(FileUtil.toSystemDependentName((String)this.getWizardContext().getProjectFileDirectory()));
        }
    }

    public void updateDataModel() {
        FlashBuilderImporter builder = (FlashBuilderImporter)this.getBuilder();
        builder.setExtractToSubfolder(this.myCreateSubfolderCheckBox.isSelected());
        builder.setExtractPath(FileUtil.toSystemIndependentName((String)((TextFieldWithBrowseButton)this.myExtractPathComponent.getComponent()).getText().trim()));
        this.getWizardContext().setProjectName(((JTextField)this.myProjectNameComponent.getComponent()).getText().trim());
        this.getWizardContext().setProjectFileDirectory(FileUtil.toSystemIndependentName((String)((TextFieldWithBrowseButton)this.myProjectLocationComponent.getComponent()).getText().trim()));
        this.myProjectFormatPanel.updateData(this.getWizardContext());
    }

    public boolean validate() throws ConfigurationException {
        String path = ((TextFieldWithBrowseButton)this.myInitialPathComponent.getComponent()).getText().trim();
        if (path.length() == 0) {
            throw new ConfigurationException(FlexBundle.message("specify.flash.builder.workspace.or.project.dir", new Object[0]), CommonBundle.getErrorTitle());
        }
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        if (file == null) {
            throw new ConfigurationException(FlexBundle.message("file.or.folder.not.found", path), CommonBundle.getErrorTitle());
        }
        if (file.isDirectory()) {
            ArrayList<String> projectPaths = new ArrayList<String>();
            boolean ok = FlashBuilderProjectFinder.collectAllProjectPaths(this.getWizardContext().getProject(), projectPaths, path);
            if (ok) {
                if (projectPaths.isEmpty()) {
                    throw new ConfigurationException(FlexBundle.message("flash.builder.projects.not.found.in", new Object[0]), CommonBundle.getErrorTitle());
                }
                ((FlashBuilderImporter)this.getBuilder()).setList(projectPaths);
            }
            return ok && this.checkProjectNameAndPath();
        }
        if (FlashBuilderProjectFinder.hasArchiveExtension(file.getPath())) {
            FlashBuilderProjectFinder.checkArchiveContainsFBProject(file.getPath());
            File dir = new File(this.getWizardContext().isCreatingNewProject() ? ((TextFieldWithBrowseButton)this.myProjectLocationComponent.getComponent()).getText().trim() : ((TextFieldWithBrowseButton)this.myExtractPathComponent.getComponent()).getText().trim());
            if (dir.isDirectory() && dir.list().length > 0) {
                String title = StringUtil.capitalizeWords((String)ProjectBundle.message((String)"project.new.wizard.import.title", (Object[])new Object[]{this.getWizardContext().getPresentationName()}), (boolean)true);
                if (0 != Messages.showYesNoDialog((Component)this.myMainPanel, (String)FlexBundle.message("folder.not.empty", dir.getPath()), (String)title, (Icon)Messages.getWarningIcon())) {
                    return false;
                }
            }
        } else if (!FlashBuilderProjectFinder.isFlashBuilderProject(file)) {
            throw new ConfigurationException(FlexBundle.message("not.flash.builder.project", new Object[0]), CommonBundle.getErrorTitle());
        }
        ((FlashBuilderImporter)this.getBuilder()).setList(Collections.singletonList(path));
        return this.checkProjectNameAndPath();
    }

    private boolean checkProjectNameAndPath() throws ConfigurationException {
        if (!this.getWizardContext().isCreatingNewProject()) {
            return true;
        }
        if (((JTextField)this.myProjectNameComponent.getComponent()).getText().trim().isEmpty()) {
            throw new ConfigurationException(FlexBundle.message("project.name.empty", new Object[0]));
        }
        if (((TextFieldWithBrowseButton)this.myProjectLocationComponent.getComponent()).getText().trim().isEmpty()) {
            throw new ConfigurationException(FlexBundle.message("project.path.empty", new Object[0]));
        }
        return true;
    }

    public String getHelpId() {
        return "reference.dialogs.new.project.import.flex.page1";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        LabeledComponent labeledComponent;
        JCheckBox jCheckBox;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        LabeledComponent labeledComponent4;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(9, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myInitialPathComponent = labeledComponent4 = new LabeledComponent();
        labeledComponent4.setText(ResourceBundle.getBundle("com/intellij/lang/javascript/flex/FlexBundle").getString("flash.builder.workspace.or.project.dir"));
        labeledComponent4.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        jPanel.add((Component)labeledComponent4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        ProjectFormatPanel projectFormatPanel = this.myProjectFormatPanel;
        JComponent jComponent = projectFormatPanel.$$$getRootComponent$$$();
        jPanel.add((Component)jComponent, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myProjectNameComponent = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setText("Project name");
        labeledComponent3.setComponentClass("javax.swing.JTextField");
        jPanel.add((Component)labeledComponent3, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myProjectLocationComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setText(ResourceBundle.getBundle("com/intellij/lang/javascript/flex/FlexBundle").getString("project.files.location"));
        labeledComponent2.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        jPanel.add((Component)labeledComponent2, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 15), null));
        this.myCreateSubfolderCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/intellij/lang/javascript/flex/FlexBundle").getString("extract.single.to.subfolder.0"));
        jPanel.add((Component)jCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myExtractPathComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setText(ResourceBundle.getBundle("com/intellij/lang/javascript/flex/FlexBundle").getString("folder.to.unzip.several.FB.projects"));
        labeledComponent.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        jPanel.add((Component)labeledComponent, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myMultiProjectNote = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("com/intellij/lang/javascript/flex/FlexBundle").getString("note.multiple.projects.extract.to.subfolders"));
        jPanel.add((Component)jLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

