/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.flexunit.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RefactoringQuickFix;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.flexunit.FlexUnitSupport;
import com.intellij.lang.javascript.flex.flexunit.inspections.FlexUnitClassInspectionBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FlexUnitClassInProductSourceInspection
extends FlexUnitClassInspectionBase {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FlexBundle.message("flexunit.inspection.testclassinproductsource.displayname", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("FlexUnitClassInProductSourceInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection", "getShortName"));
        }
        return "FlexUnitClassInProductSourceInspection";
    }

    @Override
    protected void visitPotentialTestClass(JSClass aClass, @NotNull ProblemsHolder holder, FlexUnitSupport support) {
        PsiElement nameIdentifier;
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection", "visitPotentialTestClass"));
        }
        VirtualFile file = aClass.getContainingFile().getVirtualFile();
        if (file == null) {
            return;
        }
        if (!ProjectRootManager.getInstance((Project)aClass.getProject()).getFileIndex().isInTestSourceContent(file) && (nameIdentifier = aClass.getNameIdentifier()) != null) {
            LocalQuickFix[] localQuickFixArray;
            if (holder.isOnTheFly()) {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new MoveClassFix();
            } else {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            holder.registerProblem(nameIdentifier, FlexBundle.message("flexunit.inspection.testclassinproductsource.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
        }
    }

    private static class MoveClassFix
    implements RefactoringQuickFix {
        private MoveClassFix() {
        }

        @NotNull
        public String getFamilyName() {
            if ("Move class" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection$MoveClassFix", "getFamilyName"));
            }
            return "Move class";
        }

        @NotNull
        public RefactoringActionHandler getHandler() {
            RefactoringActionHandler refactoringActionHandler = RefactoringActionHandlerFactory.getInstance().createMoveHandler();
            if (refactoringActionHandler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/flexunit/inspections/FlexUnitClassInProductSourceInspection$MoveClassFix", "getHandler"));
            }
            return refactoringActionHandler;
        }
    }
}

