/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.importer;

import com.intellij.lang.javascript.flex.importer.Abc;
import com.intellij.lang.javascript.flex.importer.ByteBuffer;
import com.intellij.lang.javascript.flex.importer.FlexByteCodeInformationProcessor;
import com.intellij.lang.javascript.flex.importer.LabelInfo;
import com.intellij.lang.javascript.flex.importer.MemberInfo;
import com.intellij.lang.javascript.flex.importer.Multiname;
import com.intellij.lang.javascript.flex.importer.Traits;
import com.intellij.openapi.util.text.StringUtil;

class MethodInfo
extends MemberInfo {
    int flags;
    String debugName;
    Multiname[] paramTypes;
    String[] paramNames;
    Multiname[] optionalValues;
    Multiname returnType;
    int local_count;
    int max_scope;
    int max_stack;
    ByteBuffer code;
    Traits activation;
    boolean anon;

    MethodInfo() {
    }

    @Override
    void dump(Abc abc, String indent, String attr, FlexByteCodeInformationProcessor processor) {
        if (!processor.doDumpMember(this)) {
            return;
        }
        processor.processFunction(this, false, abc, indent, attr);
    }

    protected void dumpCode(Abc abc, String indent, FlexByteCodeInformationProcessor processor) {
        processor.append(indent + "{\n");
        String oldindent = indent;
        indent = indent + "  ";
        if ((this.flags & 2) != 0) {
            processor.append(indent + "activation {\n");
            this.activation.dump(abc, indent + "  ", "", processor);
            processor.append(indent + "}\n");
        }
        processor.append(indent + "// local_count=" + this.local_count + " max_scope=" + this.max_scope + " max_stack=" + this.max_stack + " code_len=" + this.code.bytesSize() + "\n");
        this.code.setPosition(0);
        LabelInfo labels = new LabelInfo();
        while (!this.code.eof()) {
            int i;
            int start = this.code.getPosition();
            int opcode = this.code.readUnsignedByte();
            if (opcode == 9 || labels.containsKey(start)) {
                processor.append(indent + "\n");
                processor.append(indent + labels.labelFor(start) + ": \n");
            }
            String str = indent + start;
            processor.append(str);
            for (i = str.length(); i < 12; ++i) {
                processor.append(" ");
            }
            processor.append(Abc.opNames[opcode]);
            processor.append(Abc.opNames[opcode].length() < 8 ? "\t\t" : "\t");
            switch (opcode) {
                case 44: 
                case 241: {
                    processor.append('\"' + StringUtil.replace((String)StringUtil.replace((String)abc.strings[this.readU32()], (String)"\n", (String)"\\n"), (String)"\t", (String)"\\t") + '\"');
                    break;
                }
                case 49: {
                    processor.append(abc.namespaces[this.readU32()]);
                    break;
                }
                case 45: {
                    i = abc.ints[this.readU32()];
                    processor.append(i + "\t// 0x" + Integer.toString(i, 16));
                    break;
                }
                case 46: {
                    int u = abc.uints[this.readU32()];
                    processor.append(u + "\t// 0x" + Integer.toString(u, 16));
                    break;
                }
                case 47: {
                    processor.append(abc.doubles[this.readU32()].toString());
                    break;
                }
                case 4: 
                case 5: 
                case 89: 
                case 93: 
                case 94: 
                case 95: 
                case 96: 
                case 97: 
                case 102: 
                case 104: 
                case 106: 
                case 128: 
                case 134: 
                case 178: {
                    processor.append(abc.names[this.readU32()].toString());
                    break;
                }
                case 69: 
                case 70: 
                case 74: 
                case 76: 
                case 78: 
                case 79: {
                    processor.append(abc.names[this.readU32()].toString());
                    processor.append(" (" + this.readU32() + ")");
                    break;
                }
                case 64: {
                    int method_id = this.readU32();
                    processor.processFunction(abc.methods[method_id], true, abc, "", "");
                    abc.methods[method_id].anon = true;
                    break;
                }
                case 68: {
                    processor.processFunction(abc.methods[this.readU32()], true, abc, "", "");
                    processor.append(" (" + this.readU32() + ")");
                    break;
                }
                case 88: {
                    processor.append(abc.instances[this.readU32()].toString());
                    break;
                }
                case 27: {
                    int pos = start;
                    int target = pos + this.readS24();
                    int maxindex = this.readU32();
                    processor.append("default:" + labels.labelFor(target));
                    processor.append(" maxcase:" + maxindex);
                    for (i = 0; i <= maxindex; ++i) {
                        target = pos + this.readS24();
                        processor.append(" " + labels.labelFor(target));
                    }
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    int offset = this.readS24();
                    int target = this.code.getPosition() + offset;
                    processor.append(labels.labelFor(target));
                    if (labels.containsKey(this.code.getPosition())) break;
                    processor.append("\n");
                    break;
                }
                case 8: 
                case 37: 
                case 90: 
                case 98: 
                case 99: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 146: 
                case 148: 
                case 194: 
                case 195: 
                case 240: {
                    processor.append("" + this.readU32());
                    break;
                }
                case 239: {
                    processor.append("" + this.code.readUnsignedByte());
                    processor.append(" " + this.readU32());
                    processor.append(" " + this.code.readUnsignedByte());
                    processor.append(" " + this.readU32());
                    break;
                }
                case 85: {
                    processor.append("{" + this.readU32() + "}");
                    break;
                }
                case 86: {
                    processor.append("[" + this.readU32() + "]");
                    break;
                }
                case 65: 
                case 66: 
                case 73: {
                    processor.append("(" + this.readU32() + ")");
                    break;
                }
                case 36: 
                case 101: {
                    processor.append("" + this.code.readByte());
                    break;
                }
                case 50: {
                    processor.append(this.readU32() + " " + this.readU32());
                }
            }
            int size = this.code.getPosition() - start;
            abc.totalSize += size;
            int n = opcode;
            abc.opSizes[n] = abc.opSizes[n] + size;
            processor.append("\n");
        }
        processor.append(oldindent + "}\n");
    }

    int readU32() {
        return this.code.readU32();
    }

    int readS24() {
        int b = this.code.readUnsignedByte();
        b |= this.code.readUnsignedByte() << 8;
        return b |= this.code.readByte() << 16;
    }

    boolean isGetMethod() {
        return this.kind == Abc.TraitType.Getter;
    }

    boolean isSetMethod() {
        return this.kind == Abc.TraitType.Setter;
    }
}

