/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.library;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.library.FlexDocsRootDetector;
import com.intellij.lang.javascript.flex.library.FlexSourcesRootDetector;
import com.intellij.lang.javascript.flex.library.FlexSwcFoldersRootDetector;
import com.intellij.lang.javascript.flex.library.FlexSwcLibrariesRootDetector;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryRootType;
import com.intellij.openapi.roots.libraries.ui.DetectedLibraryRoot;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.libraries.ui.impl.LibraryRootsDetectorImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlexLibraryRootsDetector
extends LibraryRootsDetectorImpl {
    public FlexLibraryRootsDetector() {
        super(Arrays.asList(new RootDetector[]{new FlexSwcLibrariesRootDetector(), new FlexDocsRootDetector(), new FlexSourcesRootDetector(), new FlexSwcFoldersRootDetector()}));
    }

    public Collection<DetectedLibraryRoot> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
        if (rootCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCandidate", "com/intellij/lang/javascript/flex/library/FlexLibraryRootsDetector", "detectRoots"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/lang/javascript/flex/library/FlexLibraryRootsDetector", "detectRoots"));
        }
        Collection roots = super.detectRoots(rootCandidate, progressIndicator);
        boolean swcsFoldersFound = ContainerUtil.find((Iterable)roots, root -> {
            LibraryRootType libraryRootType = (LibraryRootType)root.getTypes().get(0);
            return libraryRootType.getType() == OrderRootType.CLASSES && libraryRootType.isJarDirectory();
        }) != null;
        List<LibraryRootType> types = Arrays.asList(new LibraryRootType(OrderRootType.CLASSES, false), new LibraryRootType(OrderRootType.SOURCES, false));
        if (swcsFoldersFound) {
            Collections.reverse(types);
        }
        return ContainerUtil.map((Collection)roots, root -> {
            if (((LibraryRootType)root.getTypes().get(0)).getType() == OrderRootType.SOURCES) {
                return new DetectedLibraryRoot(root.getFile(), types);
            }
            return root;
        });
    }

    public String getRootTypeName(@NotNull LibraryRootType rootType) {
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/lang/javascript/flex/library/FlexLibraryRootsDetector", "getRootTypeName"));
        }
        if (rootType.getType() == OrderRootType.SOURCES) {
            return FlexBundle.message("sources.root.detector.name", new Object[0]);
        }
        if (rootType.getType() == OrderRootType.CLASSES) {
            if (rootType.isJarDirectory()) {
                return FlexBundle.message("swc.folders.root.detector.name", new Object[0]);
            }
            return FlexBundle.message("as.libraries.root.detector.name", new Object[0]);
        }
        if (rootType.getType() instanceof JavadocOrderRootType) {
            return FlexBundle.message("docs.root.detector.name", new Object[0]);
        }
        return null;
    }
}

