/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.library;

import com.intellij.ide.util.projectWizard.importSources.util.CommonSourceRootDetectionUtil;
import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.projectStructure.detection.FlexProjectStructureDetector;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.DistinctRootsCollection;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

class FlexSourcesRootDetector
extends RootDetector {
    private final boolean myDetectMxml;

    public FlexSourcesRootDetector() {
        super(OrderRootType.SOURCES, false, FlexBundle.message("sources.root.detector.name", new Object[0]));
        this.myDetectMxml = true;
    }

    @NotNull
    public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
        if (rootCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCandidate", "com/intellij/lang/javascript/flex/library/FlexSourcesRootDetector", "detectRoots"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/lang/javascript/flex/library/FlexSourcesRootDetector", "detectRoots"));
        }
        DistinctRootsCollection<VirtualFile> result = new DistinctRootsCollection<VirtualFile>(){

            protected boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile virtualFile) {
                if (ancestor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/intellij/lang/javascript/flex/library/FlexSourcesRootDetector$1", "isAncestor"));
                }
                if (virtualFile == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/lang/javascript/flex/library/FlexSourcesRootDetector$1", "isAncestor"));
                }
                return VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)virtualFile, (boolean)false);
            }
        };
        this.collectRoots(rootCandidate, (Collection<VirtualFile>)result, rootCandidate, progressIndicator);
        DistinctRootsCollection<VirtualFile> distinctRootsCollection = result;
        if (distinctRootsCollection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/library/FlexSourcesRootDetector", "detectRoots"));
        }
        return distinctRootsCollection;
    }

    private void collectRoots(final VirtualFile startFile, final Collection<VirtualFile> result, final VirtualFile topmostRoot, final ProgressIndicator progressIndicator) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)startFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flex/library/FlexSourcesRootDetector$2", "visitFileEx"));
                }
                progressIndicator.checkCanceled();
                progressIndicator.setText2(file.getPresentableUrl());
                if (!file.isDirectory()) {
                    if (file.getFileType() == ActionScriptFileType.INSTANCE) {
                        Pair root = CommonSourceRootDetectionUtil.VIRTUAL_FILE.suggestRootForFileWithPackageStatement((Object)file, (Object)topmostRoot, FlexProjectStructureDetector.PACKAGE_NAME_FETCHER, false);
                        if (root != null) {
                            VirtualFile detectedRoot = (VirtualFile)root.first;
                            result.add(detectedRoot);
                            if (VfsUtilCore.isAncestor((VirtualFile)detectedRoot, (VirtualFile)startFile, (boolean)false)) {
                                VirtualFileVisitor.Result result2 = 2.skipTo((VirtualFile)detectedRoot);
                                if (result2 == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/library/FlexSourcesRootDetector$2", "visitFileEx"));
                                }
                                return result2;
                            }
                        }
                    } else if (FlexSourcesRootDetector.this.myDetectMxml && JavaScriptSupportLoader.isFlexMxmFile((String)file.getName())) {
                        result.add(file.getParent());
                    }
                }
                VirtualFileVisitor.Result result3 = CONTINUE;
                if (result3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/library/FlexSourcesRootDetector$2", "visitFileEx"));
                }
                return result3;
            }
        });
    }
}

