/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.library;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class FlexSwcFoldersRootDetector
extends RootDetector {
    public FlexSwcFoldersRootDetector() {
        super(OrderRootType.CLASSES, true, FlexBundle.message("swc.folders.root.detector.name", new Object[0]));
    }

    @NotNull
    public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
        if (rootCandidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootCandidate", "com/intellij/lang/javascript/flex/library/FlexSwcFoldersRootDetector", "detectRoots"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/lang/javascript/flex/library/FlexSwcFoldersRootDetector", "detectRoots"));
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        FlexSwcFoldersRootDetector.collectRoots(rootCandidate, result, progressIndicator);
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/library/FlexSwcFoldersRootDetector", "detectRoots"));
        }
        return arrayList;
    }

    private static void collectRoots(VirtualFile file, final List<VirtualFile> result, final ProgressIndicator progressIndicator) {
        if (!file.isDirectory() || file.getFileSystem() instanceof JarFileSystem) {
            return;
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile child) {
                if (child == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/flex/library/FlexSwcFoldersRootDetector$1", "visitFileEx"));
                }
                progressIndicator.checkCanceled();
                if (child.isDirectory()) {
                    progressIndicator.setText2(child.getPresentableUrl());
                } else if ("swc".equalsIgnoreCase(child.getExtension()) || "ane".equalsIgnoreCase(child.getExtension())) {
                    VirtualFile dir = child.getParent();
                    result.add(dir);
                    VirtualFileVisitor.Result result2 = 1.skipTo((VirtualFile)dir);
                    if (result2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/library/FlexSwcFoldersRootDetector$1", "visitFileEx"));
                    }
                    return result2;
                }
                VirtualFileVisitor.Result result3 = CONTINUE;
                if (result3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/library/FlexSwcFoldersRootDetector$1", "visitFileEx"));
                }
                return result3;
            }
        });
    }
}

