/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure;

import com.intellij.lang.javascript.flex.FlexBundle;
import com.intellij.lang.javascript.flex.FlexModuleType;
import com.intellij.lang.javascript.flex.library.FlexLibraryType;
import com.intellij.lang.javascript.flex.projectStructure.BuildConfigurationNode;
import com.intellij.lang.javascript.flex.projectStructure.FlexBCConfigurator;
import com.intellij.lang.javascript.flex.projectStructure.model.Dependencies;
import com.intellij.lang.javascript.flex.projectStructure.model.DependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.model.ModuleLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.options.FlexProjectRootsUtil;
import com.intellij.lang.javascript.flex.projectStructure.ui.CompositeConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.DependenciesConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexBCConfigurable;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexProjectStructureUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureExtension;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.ui.navigation.Place;
import icons.FlexIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexBuildConfigurationsExtension
extends ModuleStructureExtension {
    final FlexBCConfigurator myConfigurator = new FlexBCConfigurator();

    public static FlexBuildConfigurationsExtension getInstance() {
        return (FlexBuildConfigurationsExtension)((Object)ModuleStructureExtension.EP_NAME.findExtension(FlexBuildConfigurationsExtension.class));
    }

    public FlexBCConfigurator getConfigurator() {
        return this.myConfigurator;
    }

    public void reset(Project project) {
        this.myConfigurator.reset(project);
    }

    public boolean addModuleNodeChildren(Module module, MasterDetailsComponent.MyNode moduleNode, Runnable treeNodeNameUpdater) {
        if (!(ModuleType.get((Module)module) instanceof FlexModuleType)) {
            return false;
        }
        List<CompositeConfigurable> configurables = this.myConfigurator.getOrCreateConfigurables(module, treeNodeNameUpdater);
        for (CompositeConfigurable configurable : configurables) {
            if (MasterDetailsComponent.findNodeByObject((TreeNode)moduleNode, (Object)configurable.getEditableObject()) != null) continue;
            moduleNode.add((MutableTreeNode)((Object)new BuildConfigurationNode(configurable)));
        }
        return configurables.size() > 0;
    }

    public void moduleRemoved(Module module) {
        this.myConfigurator.moduleRemoved(module);
    }

    public boolean isModified() {
        return this.myConfigurator.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myConfigurator.apply();
    }

    public void afterModelCommit() {
        this.myConfigurator.afterModelCommit();
    }

    public void disposeUIResources() {
        this.myConfigurator.dispose();
    }

    public List<RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new RemoveConfigurableHandler<ModifiableFlexBuildConfiguration>(CompositeConfigurable.class){

            public boolean canBeRemoved(@NotNull Collection<ModifiableFlexBuildConfiguration> configurations) {
                if (configurations == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/lang/javascript/flex/projectStructure/FlexBuildConfigurationsExtension$1", "canBeRemoved"));
                }
                return FlexBuildConfigurationsExtension.this.myConfigurator.canBeRemoved(configurations.toArray(new ModifiableFlexBuildConfiguration[configurations.size()]));
            }

            public boolean remove(@NotNull Collection<ModifiableFlexBuildConfiguration> configurations) {
                if (configurations == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurations", "com/intellij/lang/javascript/flex/projectStructure/FlexBuildConfigurationsExtension$1", "remove"));
                }
                for (ModifiableFlexBuildConfiguration configuration : configurations) {
                    FlexBuildConfigurationsExtension.this.myConfigurator.removeConfiguration(configuration);
                }
                return true;
            }
        });
    }

    public boolean canBeCopied(NamedConfigurable configurable) {
        return configurable instanceof CompositeConfigurable;
    }

    public void copy(NamedConfigurable configurable, Runnable treeNodeNameUpdater) {
        this.myConfigurator.copy((CompositeConfigurable)configurable, treeNodeNameUpdater);
    }

    public Collection<AnAction> createAddActions(final NullableComputable<MasterDetailsComponent.MyNode> selectedNodeRetriever, final Runnable treeNodeNameUpdater, Project project, MasterDetailsComponent.MyNode root) {
        ArrayList<AnAction> actions = new ArrayList<AnAction>(2);
        actions.add((AnAction)new DumbAwareAction(FlexBundle.message("create.bc.action.text", new Object[0]), FlexBundle.message("create.bc.action.description", new Object[0]), FlexIcons.Flash_run_config){

            public void update(AnActionEvent e) {
                e.getPresentation().setVisible(FlexBuildConfigurationsExtension.getFlexModuleForNode((MasterDetailsComponent.MyNode)selectedNodeRetriever.compute()) != null);
            }

            public void actionPerformed(AnActionEvent e) {
                Module module = FlexBuildConfigurationsExtension.getFlexModuleForNode((MasterDetailsComponent.MyNode)selectedNodeRetriever.compute());
                FlexBuildConfigurationsExtension.this.myConfigurator.addConfiguration(module, treeNodeNameUpdater);
            }
        });
        return actions;
    }

    @Nullable
    private static Module getFlexModuleForNode(@Nullable MasterDetailsComponent.MyNode node) {
        while (node != null) {
            Object editableObject;
            NamedConfigurable configurable = node.getConfigurable();
            Object object = editableObject = configurable == null ? null : configurable.getEditableObject();
            if (editableObject instanceof Module && ModuleType.get((Module)((Module)editableObject)) instanceof FlexModuleType) {
                return (Module)editableObject;
            }
            TreeNode parent = node.getParent();
            node = parent instanceof MasterDetailsComponent.MyNode ? (MasterDetailsComponent.MyNode)parent : null;
        }
        return null;
    }

    @Nullable
    public ActionCallback selectOrderEntry(@NotNull Module module, @Nullable OrderEntry entry) {
        Library library;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/flex/projectStructure/FlexBuildConfigurationsExtension", "selectOrderEntry"));
        }
        if (ModuleType.get((Module)module) != FlexModuleType.getInstance()) {
            return null;
        }
        if (entry instanceof LibraryOrderEntry && (library = ((LibraryOrderEntry)entry).getLibrary()) != null && library.getTable() == null && ((LibraryEx)library).getKind() == FlexLibraryType.FLEX_LIBRARY) {
            String libraryId = FlexProjectRootsUtil.getLibraryId(library);
            List<CompositeConfigurable> configurables = this.myConfigurator.getBCConfigurables(module);
            for (CompositeConfigurable configurable : configurables) {
                FlexBCConfigurable bcConfigurable = FlexBCConfigurable.unwrap(configurable);
                Dependencies dependencies = bcConfigurable.getDependenciesConfigurable().getEditableObject();
                for (DependencyEntry e : dependencies.getEntries()) {
                    if (!(e instanceof ModuleLibraryEntry) || !((ModuleLibraryEntry)e).getLibraryId().equals(libraryId)) continue;
                    Place p = FlexProjectStructureUtil.createPlace(bcConfigurable, DependenciesConfigurable.TAB_NAME);
                    DependenciesConfigurable.Location.TableEntry tableEntry = DependenciesConfigurable.Location.TableEntry.forModuleLibrary(libraryId);
                    p.putPath("FlashBuildConfiguration.locationOnTab", (Object)tableEntry);
                    return ProjectStructureConfigurable.getInstance((Project)module.getProject()).navigateTo(p, true);
                }
            }
        }
        return ProjectStructureConfigurable.getInstance((Project)module.getProject()).select(module.getName(), null, true);
    }
}

