/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure;

import org.jetbrains.annotations.Nullable;

public abstract class LazyInitializer<T> {
    @Nullable
    private T myInitializedFor;

    public void ensureInitialized(T t) {
        if (this.myInitializedFor == null) {
            this.initialize(t);
            this.myInitializedFor = t;
        } else if (this.myInitializedFor != t) {
            throw new IllegalArgumentException("Trying to initialize for different entity " + t + ", was originally initialized for " + this.myInitializedFor);
        }
    }

    protected abstract void initialize(T var1);

    public final void dispose() {
        this.myInitializedFor = null;
        this.doDispose();
    }

    protected abstract void doDispose();
}

