/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.model.impl;

import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableDependencyType;
import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableSharedLibraryEntry;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.DependencyTypeImpl;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.EntryState;
import com.intellij.lang.javascript.flex.projectStructure.model.impl.StatefulDependencyEntry;
import org.jetbrains.annotations.NotNull;

class SharedLibraryEntryImpl
implements ModifiableSharedLibraryEntry,
StatefulDependencyEntry {
    private final DependencyTypeImpl myDependencyType;
    @NotNull
    private final String myLibraryName;
    @NotNull
    private final String myLibraryLevel;

    public SharedLibraryEntryImpl(@NotNull String libraryName, @NotNull String libraryLevel) {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/intellij/lang/javascript/flex/projectStructure/model/impl/SharedLibraryEntryImpl", "<init>"));
        }
        if (libraryLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryLevel", "com/intellij/lang/javascript/flex/projectStructure/model/impl/SharedLibraryEntryImpl", "<init>"));
        }
        this.myDependencyType = new DependencyTypeImpl();
        this.myLibraryName = libraryName;
        this.myLibraryLevel = libraryLevel;
    }

    @Override
    @NotNull
    public String getLibraryName() {
        String string = this.myLibraryName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/SharedLibraryEntryImpl", "getLibraryName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getLibraryLevel() {
        String string = this.myLibraryLevel;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/SharedLibraryEntryImpl", "getLibraryLevel"));
        }
        return string;
    }

    @Override
    @NotNull
    public DependencyTypeImpl getDependencyType() {
        DependencyTypeImpl dependencyTypeImpl = this.myDependencyType;
        if (dependencyTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/flex/projectStructure/model/impl/SharedLibraryEntryImpl", "getDependencyType"));
        }
        return dependencyTypeImpl;
    }

    public SharedLibraryEntryImpl getCopy() {
        SharedLibraryEntryImpl copy = new SharedLibraryEntryImpl(this.myLibraryName, this.myLibraryLevel);
        this.applyTo(copy);
        return copy;
    }

    private void applyTo(ModifiableSharedLibraryEntry copy) {
        this.myDependencyType.applyTo((ModifiableDependencyType)copy.getDependencyType());
    }

    @Override
    public boolean isEqual(ModifiableDependencyEntry other) {
        if (!(other instanceof SharedLibraryEntryImpl)) {
            return false;
        }
        if (!this.myLibraryName.equals(((SharedLibraryEntryImpl)other).myLibraryName)) {
            return false;
        }
        if (!this.myLibraryLevel.equals(((SharedLibraryEntryImpl)other).myLibraryLevel)) {
            return false;
        }
        return this.myDependencyType.isEqual(((SharedLibraryEntryImpl)other).myDependencyType);
    }

    @Override
    public EntryState getState() {
        EntryState state = new EntryState();
        state.LIBRARY_NAME = this.myLibraryName;
        state.LIBRARY_LEVEL = this.myLibraryLevel;
        state.DEPENDENCY_TYPE = this.myDependencyType.getState();
        return state;
    }
}

