/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.projectStructure.ui;

import com.intellij.lang.javascript.flex.projectStructure.model.ModifiableFlexBuildConfiguration;
import com.intellij.lang.javascript.flex.projectStructure.ui.FlexBCConfigurable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeConfigurable
extends ProjectStructureElementConfigurable<ModifiableFlexBuildConfiguration>
implements Place.Navigator {
    public static final String TAB_NAME = "tabName";
    private final FlexBCConfigurable myMainChild;
    private final List<NamedConfigurable> myChildren = new ArrayList<NamedConfigurable>();
    private final Disposable myDisposable = Disposer.newDisposable();
    private final TabbedPaneWrapper myTabs;

    public CompositeConfigurable(FlexBCConfigurable mainChild, List<NamedConfigurable> otherChildren, Runnable updateTree) {
        super(false, updateTree);
        this.myMainChild = mainChild;
        this.myTabs = new TabbedPaneWrapper(this.myDisposable);
        this.myChildren.add((NamedConfigurable)mainChild);
        this.myChildren.addAll(otherChildren);
    }

    public void setDisplayName(String name) {
        this.getMainChild().setDisplayName(name);
    }

    public FlexBCConfigurable getMainChild() {
        return this.myMainChild;
    }

    public ModifiableFlexBuildConfiguration getEditableObject() {
        return this.getMainChild().getEditableObject();
    }

    public String getBannerSlogan() {
        return this.getMainChild().getBannerSlogan();
    }

    public JComponent createOptionsPanel() {
        for (NamedConfigurable child : this.myChildren) {
            this.addTab(child);
        }
        return this.myTabs.getComponent();
    }

    private void addTab(NamedConfigurable child) {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(IdeBorderFactory.createEmptyBorder((int)5));
        p.add((Component)child.createComponent(), "Center");
        String tabName = child instanceof Item ? ((Item)child).getTabTitle() : child.getDisplayName();
        this.myTabs.addTab(tabName, (JComponent)p);
    }

    public List<NamedConfigurable> getChildren() {
        return this.myChildren;
    }

    public void addChild(NamedConfigurable child) {
        this.myChildren.add(child);
        this.addTab(child);
    }

    public void removeChildAt(int index) {
        this.myChildren.remove(index);
        this.myTabs.removeTabAt(index);
    }

    @Nls
    public String getDisplayName() {
        return this.getMainChild().getDisplayName();
    }

    public Icon getIcon(boolean expanded) {
        return FlexBCConfigurable.unwrap(this).getIcon();
    }

    public String getHelpTopic() {
        String helpTopic = this.myChildren.get(this.myTabs.getSelectedIndex()).getHelpTopic();
        return helpTopic != null ? helpTopic : this.getMainChild().getHelpTopic();
    }

    public boolean isModified() {
        return this.getMainChild().isModified();
    }

    public void apply() throws ConfigurationException {
        this.getMainChild().apply();
    }

    public void reset() {
        this.getMainChild().reset();
    }

    public void disposeUIResources() {
        this.getMainChild().disposeUIResources();
        Disposer.dispose((Disposable)this.myDisposable);
    }

    public void setHistory(History history) {
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        if (place == null) {
            return ActionCallback.DONE;
        }
        Object tabName = place.getPath(TAB_NAME);
        if (tabName instanceof String) {
            for (int i = 0; i < this.myChildren.size(); ++i) {
                NamedConfigurable child = this.myChildren.get(i);
                if (!tabName.equals(child.getDisplayName())) continue;
                this.myTabs.setSelectedIndex(i);
                return Place.goFurther((Object)child, (Place)place, (boolean)requestFocus);
            }
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/lang/javascript/flex/projectStructure/ui/CompositeConfigurable", "queryPlace"));
        }
        NamedConfigurable child = this.myChildren.get(this.myTabs.getSelectedIndex());
        place.putPath(TAB_NAME, (Object)child.getDisplayName());
    }

    @Nullable
    public ProjectStructureElement getProjectStructureElement() {
        FlexBCConfigurable mainChild = this.getMainChild();
        if (mainChild instanceof ProjectStructureElementConfigurable) {
            return ((ProjectStructureElementConfigurable)mainChild).getProjectStructureElement();
        }
        return null;
    }

    public static interface Item {
        public String getTabTitle();
    }
}

