/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex.sdk;

import com.intellij.lang.javascript.flex.sdk.FlexSdkUtils;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.Nullable;

public class FlexmojosSdkAdditionalData
implements SdkAdditionalData {
    private static final String COMPILER_CLASSPATH_ELEMENT_NAME = "CompilerClassPath";
    private static final String CLASSPATH_ENTRY_ELEMENT_NAME = "ClassPathEntry";
    private static final String ADL_PATH_ELEMENT_NAME = "AdlPath";
    private static final String AIR_RUNTIME_PATH_ELEMENT_NAME = "AirRuntimePath";
    private static final String COMPILER_POM_NAME_BEGINNING = "compiler-";
    private static final String DOT_POM = ".pom";
    private static final String ADL_ARTIFACT_PATTERN = "{0}/com/adobe/flex/adl/{1}/adl-{1}.{2}";
    private static final String AIR_RUNTIME_ARTIFACT_PATTERN = "{0}/com/adobe/air/runtime/{1}/runtime-{1}-{2}.{3}";
    private Collection<String> myFlexCompilerClasspath = new ArrayList<String>();
    private String myAdlPath = "";
    private String myAirRuntimePath = "";

    public Object clone() throws CloneNotSupportedException {
        FlexmojosSdkAdditionalData copy = (FlexmojosSdkAdditionalData)super.clone();
        copy.myFlexCompilerClasspath = new ArrayList<String>(this.myFlexCompilerClasspath);
        return copy;
    }

    public Collection<String> getFlexCompilerClasspath() {
        return Collections.unmodifiableCollection(this.myFlexCompilerClasspath);
    }

    public void addFlexCompilerClasspathEntryIfNotPresentAndRemoveDifferentVersionOfThisJar(Pattern jarNamePattern, String jarPath) {
        Iterator<String> iterator = this.myFlexCompilerClasspath.iterator();
        while (iterator.hasNext()) {
            String classpathEntry = iterator.next();
            String jarName = classpathEntry.substring(classpathEntry.lastIndexOf("/") + 1);
            Matcher matcher = jarNamePattern.matcher(jarName);
            if (!matcher.find() || matcher.start() != 0) continue;
            iterator.remove();
        }
        this.myFlexCompilerClasspath.add(jarPath);
    }

    public String getAdlPath() {
        return this.myAdlPath;
    }

    public void setAdlPath(String adlPath) {
        this.myAdlPath = adlPath;
    }

    public String getAirRuntimePath() {
        return this.myAirRuntimePath;
    }

    public void setAirRuntimePath(String airRuntimePath) {
        this.myAirRuntimePath = airRuntimePath;
    }

    void setup(VirtualFile compilerPomFile) {
        String repositoryRootPath;
        String compilerPomPath = compilerPomFile.getPath();
        if (compilerPomPath.matches(".+/com/adobe/flex/compiler/.+/compiler-.+\\.pom")) {
            repositoryRootPath = compilerPomPath.substring(0, compilerPomPath.indexOf("/com/adobe/flex/compiler"));
        } else if (compilerPomPath.matches(".+/org/apache/flex/compiler/.+/compiler-.+\\.pom")) {
            repositoryRootPath = compilerPomPath.substring(0, compilerPomPath.indexOf("/org/apache/flex/compiler"));
        } else {
            return;
        }
        this.setupFlexCompilerClasspath(compilerPomFile, repositoryRootPath);
        int i = compilerPomPath.lastIndexOf(COMPILER_POM_NAME_BEGINNING);
        String version = compilerPomPath.substring(i + COMPILER_POM_NAME_BEGINNING.length(), compilerPomPath.lastIndexOf(DOT_POM));
        this.setupAirPaths(repositoryRootPath, version);
    }

    void setupFlexCompilerClasspath(VirtualFile compilerPomFile, String repositoryRootPath) {
        this.myFlexCompilerClasspath.clear();
        try {
            Element rootElement = JDOMUtil.load((InputStream)compilerPomFile.getInputStream());
            if (!rootElement.getName().equals("project")) {
                return;
            }
            for (Object dependenciesElement : rootElement.getChildren("dependencies", rootElement.getNamespace())) {
                for (Object dependencyElement : ((Element)dependenciesElement).getChildren("dependency", rootElement.getNamespace())) {
                    String groupId = ((Element)dependencyElement).getChildText("groupId", rootElement.getNamespace());
                    String artifactId = ((Element)dependencyElement).getChildText("artifactId", rootElement.getNamespace());
                    String version = ((Element)dependencyElement).getChildText("version", rootElement.getNamespace());
                    this.addClasspathEntry(repositoryRootPath, groupId, artifactId, version);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (JDOMException jDOMException) {
            // empty catch block
        }
    }

    private void setupAirPaths(String repositoryRootPath, String version) {
        if (StringUtil.isNotEmpty((String)this.myAdlPath) && StringUtil.isNotEmpty((String)this.myAirRuntimePath)) {
            return;
        }
        String exeType = SystemInfo.isWindows ? "exe" : "uexe";
        String adlPath = FileUtil.toSystemIndependentName((String)MessageFormat.format(ADL_ARTIFACT_PATTERN, repositoryRootPath, version, exeType));
        VirtualFile adlFile = LocalFileSystem.getInstance().findFileByPath(adlPath);
        if (adlFile != null && !adlFile.isDirectory()) {
            this.myAdlPath = adlPath;
            String classifier = SystemInfo.isWindows ? "win" : "mac";
            String zipType = "zip";
            this.myAirRuntimePath = FileUtil.toSystemIndependentName((String)MessageFormat.format(AIR_RUNTIME_ARTIFACT_PATTERN, repositoryRootPath, version, classifier, "zip"));
        } else {
            Sdk sdk = FlexmojosSdkAdditionalData.findSimilarSdk(version);
            if (sdk != null) {
                this.myAdlPath = FileUtil.toSystemIndependentName((String)(sdk.getHomePath() + FlexSdkUtils.ADL_RELATIVE_PATH));
                this.myAirRuntimePath = FileUtil.toSystemIndependentName((String)(sdk.getHomePath() + FlexSdkUtils.AIR_RUNTIME_RELATIVE_PATH));
            }
        }
    }

    @Nullable
    private static Sdk findSimilarSdk(String version) {
        int firstDotIndex = version.indexOf(46);
        int secondDotIndex = version.indexOf(46, firstDotIndex + 1);
        int thirdDotIndex = version.indexOf(46, secondDotIndex + 1);
        if (firstDotIndex <= 0) {
            return null;
        }
        String major = version.substring(0, firstDotIndex);
        String minor = secondDotIndex > firstDotIndex ? version.substring(firstDotIndex + 1, secondDotIndex) : "";
        String revision = thirdDotIndex > secondDotIndex ? version.substring(secondDotIndex + 1, thirdDotIndex) : "";
        String build = thirdDotIndex > 0 ? version.substring(thirdDotIndex + 1) : "";
        Sdk matchingMajorMinorRevisionBuild = null;
        Sdk matchingMajorMinorRevision = null;
        Sdk matchingMajorMinor = null;
        Sdk latestSdk = null;
        for (Sdk sdk : FlexSdkUtils.getFlexSdks()) {
            String candidateVersion = sdk.getVersionString();
            if (candidateVersion == null) continue;
            if (candidateVersion.startsWith(major + "." + minor + "." + revision) && candidateVersion.endsWith(build)) {
                matchingMajorMinorRevisionBuild = sdk;
                break;
            }
            if (candidateVersion.startsWith(major + "." + minor + "." + revision)) {
                matchingMajorMinorRevision = sdk;
            }
            if (candidateVersion.startsWith(major + "." + minor)) {
                matchingMajorMinor = sdk;
            }
            if (latestSdk != null && StringUtil.compareVersionNumbers((String)candidateVersion, (String)latestSdk.getVersionString()) <= 0) continue;
            latestSdk = sdk;
        }
        if (matchingMajorMinorRevisionBuild != null) {
            return matchingMajorMinorRevisionBuild;
        }
        if (matchingMajorMinorRevision != null) {
            return matchingMajorMinorRevision;
        }
        if (matchingMajorMinor != null) {
            return matchingMajorMinor;
        }
        return latestSdk;
    }

    private void addClasspathEntry(String repositoryRootPath, String groupId, String artifactId, String version) {
        if (StringUtil.isNotEmpty((String)repositoryRootPath) && StringUtil.isNotEmpty((String)groupId) && StringUtil.isNotEmpty((String)artifactId) && StringUtil.isNotEmpty((String)version)) {
            this.myFlexCompilerClasspath.add(repositoryRootPath + '/' + groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + artifactId + '-' + version + ".jar");
        }
    }

    void save(Element element) {
        Element compilerClasspathElement = new Element(COMPILER_CLASSPATH_ELEMENT_NAME);
        for (String classpathEntry : this.myFlexCompilerClasspath) {
            Element classpathEntryElement = new Element(CLASSPATH_ENTRY_ELEMENT_NAME);
            classpathEntryElement.setText(classpathEntry);
            compilerClasspathElement.addContent(classpathEntryElement);
        }
        element.addContent(compilerClasspathElement);
        Element adlPathElement = new Element(ADL_PATH_ELEMENT_NAME);
        adlPathElement.setText(this.myAdlPath);
        element.addContent(adlPathElement);
        Element airRuntimePathElement = new Element(AIR_RUNTIME_PATH_ELEMENT_NAME);
        airRuntimePathElement.setText(this.myAirRuntimePath);
        element.addContent(airRuntimePathElement);
    }

    void load(Element element) {
        String adlPath;
        this.myFlexCompilerClasspath.clear();
        Element compilerClasspathElement = element.getChild(COMPILER_CLASSPATH_ELEMENT_NAME);
        if (compilerClasspathElement != null) {
            for (Object classpathEntryElement : compilerClasspathElement.getChildren(CLASSPATH_ENTRY_ELEMENT_NAME)) {
                this.myFlexCompilerClasspath.add(((Element)classpathEntryElement).getText());
            }
        }
        this.myAdlPath = (adlPath = element.getChildText(ADL_PATH_ELEMENT_NAME)) == null ? "" : FileUtil.toSystemIndependentName((String)adlPath);
        String airRuntimePath = element.getChildText(AIR_RUNTIME_PATH_ELEMENT_NAME);
        this.myAirRuntimePath = airRuntimePath == null ? "" : FileUtil.toSystemIndependentName((String)airRuntimePath);
    }
}

