/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSNamedElementNode;
import com.intellij.lang.javascript.generation.JavaScriptGenerateAccessorHandler;
import com.intellij.lang.javascript.generation.OverrideMethodsFix;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMethodsFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptGenerateDelegatesHandler
extends BaseJSGenerateHandler {
    public static final String[] PRIMITIVE_TYPES = JSCommonTypeNames.ALL;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.generation.JavaScriptGenerateDelegatesHandler");

    public boolean isValidFor(Editor editor, PsiFile file) {
        if (!super.isValidFor(editor, file)) {
            return false;
        }
        return !JavaScriptGenerateDelegatesHandler.findCandidateFields(JavaScriptGenerateDelegatesHandler.findClass((PsiFile)file, (Editor)editor)).isEmpty();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        List selected;
        JSField field;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/generation/JavaScriptGenerateDelegatesHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/javascript/generation/JavaScriptGenerateDelegatesHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/generation/JavaScriptGenerateDelegatesHandler", "invoke"));
        }
        final JSClass jsClass = JavaScriptGenerateDelegatesHandler.findClass((PsiFile)file, (Editor)editor);
        if (jsClass == null) {
            return;
        }
        Collection<JSField> fields = JavaScriptGenerateDelegatesHandler.findCandidateFields(jsClass);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.assertTrue(fields.size() == 1);
            field = fields.iterator().next();
        } else {
            MemberChooser targetChooser = this.createMemberChooserDialog(project, jsClass, JavaScriptGenerateDelegatesHandler.wrap(fields), false, false, CodeInsightBundle.message((String)"generate.delegate.target.chooser.title", (Object[])new Object[0]));
            targetChooser.show();
            if (targetChooser.getExitCode() != 0) {
                return;
            }
            field = (JSField)((JSNamedElementNode)targetChooser.getSelectedElements().get(0)).getPsiElement();
        }
        JSType fieldType = field.getType();
        if (fieldType == null) {
            return;
        }
        JSClass fieldClass = fieldType.resolveClass();
        if (fieldClass == null) {
            return;
        }
        final boolean allowPackageLocal = !JSPsiImplUtils.differentPackageName((String)StringUtil.getPackageName((String)fieldClass.getQualifiedName()), (String)StringUtil.getPackageName((String)jsClass.getQualifiedName()));
        final HashMap memberCandidates = new HashMap();
        ResolveProcessor p = new ResolveProcessor(null){
            {
                super(arg0);
                this.setToProcessHierarchy(true);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                class MemberDescriptor {
                    private final String name;
                    @Nullable
                    private final JSFunction.FunctionKind kind;

                    public MemberDescriptor(JSFunction method) {
                        this.name = method.getName();
                        this.kind = method.getKind();
                    }

                    public MemberDescriptor(JSVariable field) {
                        this.name = field.getName();
                        this.kind = null;
                    }

                    public boolean equals(Object o) {
                        if (this == o) {
                            return true;
                        }
                        if (o == null || this.getClass() != o.getClass()) {
                            return false;
                        }
                        MemberDescriptor that = (MemberDescriptor)o;
                        if (this.kind != that.kind) {
                            return false;
                        }
                        return this.name.equals(that.name);
                    }

                    public int hashCode() {
                        int result = this.name.hashCode();
                        result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
                        return result;
                    }
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/generation/JavaScriptGenerateDelegatesHandler$1", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/generation/JavaScriptGenerateDelegatesHandler$1", "execute"));
                }
                JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)element);
                if (clazz == null || JSResolveUtil.isObjectClass((JSClass)clazz) || clazz == jsClass) {
                    return true;
                }
                if (element instanceof JSFunction) {
                    JSFunction method = (JSFunction)element;
                    if (memberCandidates.containsKey(method.getName())) {
                        return true;
                    }
                    JSAttributeList attributeList = method.getAttributeList();
                    if (attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE || attributeList.getAccessType() == JSAttributeList.AccessType.PROTECTED) {
                        return true;
                    }
                    if (!allowPackageLocal && attributeList.getNamespace() == null && attributeList.getAccessType() == JSAttributeList.AccessType.PACKAGE_LOCAL) {
                        return true;
                    }
                    if (method.getKind() == JSFunction.FunctionKind.CONSTRUCTOR) {
                        return true;
                    }
                    if (attributeList.hasModifier(JSAttributeList.ModifierType.STATIC)) {
                        return true;
                    }
                    if (JSInheritanceUtil.findMethodInClass((JSFunction)method, (JSClass)jsClass, (boolean)true) != null) {
                        return true;
                    }
                    memberCandidates.put(new MemberDescriptor(method), method);
                } else if (element instanceof JSVariable) {
                    JSVariable f = (JSVariable)element;
                    if (memberCandidates.containsKey(f.getName())) {
                        return true;
                    }
                    JSAttributeList attributeList = f.getAttributeList();
                    if (attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE || attributeList.getAccessType() == JSAttributeList.AccessType.PROTECTED) {
                        return true;
                    }
                    if (!allowPackageLocal && attributeList.getAccessType() == JSAttributeList.AccessType.PACKAGE_LOCAL) {
                        return true;
                    }
                    if (jsClass.findFunctionByName(f.getName()) != null) {
                        return true;
                    }
                    memberCandidates.put(new MemberDescriptor(f), f);
                }
                return true;
            }
        };
        fieldClass.processDeclarations((PsiScopeProcessor)p, ResolveState.initial(), (PsiElement)fieldClass, (PsiElement)fieldClass);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.assertTrue(!memberCandidates.isEmpty());
            selected = JavaScriptGenerateDelegatesHandler.wrap(memberCandidates.values());
        } else {
            MemberChooser methodsChooser = this.createMemberChooserDialog(project, jsClass, JavaScriptGenerateDelegatesHandler.wrap(memberCandidates.values()), false, true, CodeInsightBundle.message((String)"generate.delegate.method.chooser.title", (Object[])new Object[0]));
            methodsChooser.show();
            if (methodsChooser.getExitCode() != 0) {
                return;
            }
            selected = methodsChooser.getSelectedElements();
        }
        BaseCreateMethodsFix<JSNamedElement> fix = new BaseCreateMethodsFix<JSNamedElement>(jsClass){
            final JavaScriptGenerateAccessorHandler.MyBaseCreateMethodsFix generateGetterFix;
            final JavaScriptGenerateAccessorHandler.MyBaseCreateMethodsFix generateSetterFix;
            {
                super(arg0);
                this.generateGetterFix = new JavaScriptGenerateAccessorHandler.MyBaseCreateMethodsFix(JavaScriptGenerateAccessorHandler.GenerationMode.Getter, jsClass, null, false, field.getName());
                this.generateSetterFix = new JavaScriptGenerateAccessorHandler.MyBaseCreateMethodsFix(JavaScriptGenerateAccessorHandler.GenerationMode.Setter, jsClass, null, false, field.getName());
            }

            protected void adjustAttributeList(JSAttributeListWrapper attributeListWrapper, JSNamedElement function) {
                attributeListWrapper.overrideAccessType(JSAttributeList.AccessType.PUBLIC);
                attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.STATIC, field.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC));
                for (JSAttributeList.ModifierType modifierType : new JSAttributeList.ModifierType[]{JSAttributeList.ModifierType.NATIVE, JSAttributeList.ModifierType.DYNAMIC, JSAttributeList.ModifierType.FINAL, JSAttributeList.ModifierType.OVERRIDE, JSAttributeList.ModifierType.VIRTUAL}) {
                    attributeListWrapper.overrideModifier(modifierType, false);
                }
            }

            protected void processElements(Project project, MultiMap<String, String> types, Set<JSNamedElement> elementsToProcess) {
                for (JSNamedElement e : elementsToProcess) {
                    if (e instanceof JSFunction) {
                        this.anchor = this.doAddOneMethod(project, this.buildFunctionText(e, types), this.anchor);
                        continue;
                    }
                    this.anchor = this.doAddOneMethod(project, this.generateGetterFix.buildFunctionText(e, types), this.anchor);
                    this.anchor = this.doAddOneMethod(project, this.generateSetterFix.buildFunctionText(e, types), this.anchor);
                }
            }

            protected String buildFunctionBodyText(String retType, JSParameterList parameterList, JSNamedElement element) {
                return OverrideMethodsFix.buildDelegatingText((String)retType, (JSParameterList)parameterList, (JSFunction)((JSFunction)element), (String)field.getName(), (PsiElement)(this.anchor != null ? this.anchor : this.myJsClass));
            }
        };
        this.doInvoke(project, editor, file, selected, (BaseCreateMethodsFix)fix);
    }

    private static Collection<JSNamedElementNode> wrap(Collection<? extends JSNamedElement> items) {
        ArrayList<JSNamedElementNode> targetCandidates = new ArrayList<JSNamedElementNode>(items.size());
        for (JSNamedElement jSNamedElement : items) {
            targetCandidates.add(new JSNamedElementNode((JSPsiNamedElementBase)jSNamedElement));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Collections.sort(targetCandidates, (o1, o2) -> o1.getText().compareTo(o2.getText()));
        }
        return targetCandidates;
    }

    protected String getTitleKey() {
        return null;
    }

    protected void collectCandidates(JSClass clazz, Collection<JSNamedElementNode> candidates) {
        Collection<JSField> fields = JavaScriptGenerateDelegatesHandler.findCandidateFields(clazz);
        for (JSField field : fields) {
            candidates.add(new JSNamedElementNode((JSPsiNamedElementBase)field));
        }
    }

    protected BaseCreateMethodsFix createFix(JSClass clazz) {
        return null;
    }

    private static Collection<JSField> findCandidateFields(JSClass clazz) {
        ArrayList<JSField> result = new ArrayList<JSField>();
        for (JSField field : clazz.getFields()) {
            JSClass fieldType;
            JSType type = field.getType();
            JSClass jSClass = fieldType = type != null ? type.resolveClass() : null;
            if (fieldType == null || ArrayUtil.contains((String)fieldType.getQualifiedName(), (String[])PRIMITIVE_TYPES) || JSInheritanceUtil.isParentClass((JSClass)clazz, (JSClass)fieldType, (boolean)false)) continue;
            result.add(field);
        }
        return result;
    }
}

