/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections.actionscript;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.lang.javascript.validation.fixes.CreateConstructorFix;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ActionScriptFunctionSignatureChecker
extends JSFunctionSignatureChecker {
    private final JSAnnotatorProblemReporter myReporter;

    public ActionScriptFunctionSignatureChecker(JSTypeChecker typeChecker, JSAnnotatorProblemReporter reporter) {
        super(typeChecker);
        this.myReporter = reporter;
    }

    protected void registerProblem(JSCallExpression callExpression, String message, LocalQuickFix ... fixes) {
        PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem((JSCallExpression)callExpression, (JSArgumentList)callExpression.getArgumentList());
        this.myTypeChecker.registerProblem(place, message, ProblemHighlightType.GENERIC_ERROR, fixes);
    }

    public void checkFunction(@NotNull JSCallExpression node, @NotNull PsiElement element) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptFunctionSignatureChecker", "checkFunction"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptFunctionSignatureChecker", "checkFunction"));
        }
        super.checkFunction(node, element);
        if (element instanceof JSClass) {
            if (node instanceof JSNewExpression || node.getMethodExpression() instanceof JSSuperExpression) {
                JSExpression[] expressions;
                JSArgumentList argumentList = node.getArgumentList();
                JSExpression[] jSExpressionArray = expressions = argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY;
                if (expressions.length > 0) {
                    LocalQuickFix[] localQuickFixArray;
                    CreateConstructorFix fix = CreateConstructorFix.createIfApplicable(node);
                    String string = JSBundle.message((String)"javascript.invalid.number.of.parameters", (Object[])new Object[]{"0"});
                    if (fix != null) {
                        LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                        localQuickFixArray = localQuickFixArray2;
                        localQuickFixArray2[0] = fix;
                    } else {
                        localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                    }
                    this.registerProblem(node, string, localQuickFixArray);
                    return;
                }
                this.checkCallParameters(node, null);
            } else {
                this.reportProblemIfNotExpectedCountOfParameters(node, 1, "one");
            }
        }
    }

    protected boolean isCallableType(boolean inNewExpression, @NotNull JSType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/inspections/actionscript/ActionScriptFunctionSignatureChecker", "isCallableType"));
        }
        String typeText = type.getTypeText();
        return "Class".equals(typeText) || inNewExpression && type instanceof JSObjectType || JSTypeUtils.hasFunctionType((JSType)type);
    }

    protected void checkCallArgumentType(JSParameterItem p, JSExpression expression, JSCallExpression node, PsiElement resolveResult) {
        if (p instanceof JSParameter) {
            this.myTypeChecker.checkExpressionIsAssignableToVariable((JSVariable)((JSParameter)p), expression, node.getContainingFile(), "javascript.argument.type.mismatch", false);
        }
    }

    protected boolean obtainNextMatchedParams(int[] matchedParams, JSParameterItem[] parameters) {
        return false;
    }
}

