/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.uml;

import com.intellij.diagram.DiagramRelationshipInfo;
import com.intellij.diagram.DiagramRelationshipInfoAdapter;
import com.intellij.diagram.DiagramRelationships;
import com.intellij.diagram.presentation.DiagramLineType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.awt.Shape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FlashUmlRelationship
extends DiagramRelationshipInfo {
    public static final DiagramRelationshipInfo INTERFACE_GENERALIZATION = DiagramRelationships.INTERFACE_GENERALIZATION;
    public static final DiagramRelationshipInfo GENERALIZATION = DiagramRelationships.GENERALIZATION;
    public static final DiagramRelationshipInfo REALIZATION = DiagramRelationships.REALIZATION;
    public static final DiagramRelationshipInfo ANNOTATION = DiagramRelationships.ANNOTATION;
    public static final String TYPE_DEPENDENCY = "DEPENDENCY";
    public static final String TYPE_CREATE = "CREATE";
    public static final String TYPE_ONE_TO_ONE = "ONE_TO_ONE";
    public static final String TYPE_ONE_TO_MANY = "ONE_TO_MANY";

    @NotNull
    public String getType();

    @Nullable
    public PsiElement getElement();

    public static class Factory {
        public static FlashUmlRelationship dependency(@Nullable String label, @NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/uml/FlashUmlRelationship$Factory", "dependency"));
            }
            return new Impl(FlashUmlRelationship.TYPE_DEPENDENCY, DiagramLineType.DASHED, StringUtil.notNullize((String)label), null, null, 1, DiagramRelationships.getAngleArrow(), null, element, label != null);
        }

        public static FlashUmlRelationship create(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/uml/FlashUmlRelationship$Factory", "create"));
            }
            return new Impl(FlashUmlRelationship.TYPE_CREATE, DiagramLineType.DASHED, DiagramRelationships.CREATE.getLabel(), null, null, 1, DiagramRelationships.getAngleArrow(), null, element, false);
        }

        public static FlashUmlRelationship oneToOne(String label, @NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/uml/FlashUmlRelationship$Factory", "oneToOne"));
            }
            return new Impl(FlashUmlRelationship.TYPE_ONE_TO_ONE, DiagramLineType.SOLID, label, "1", "1", 1, DiagramRelationships.getAngleArrow(), DiagramRelationshipInfo.DIAMOND, element, true);
        }

        public static FlashUmlRelationship oneToMany(String label, @NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/uml/FlashUmlRelationship$Factory", "oneToMany"));
            }
            return new Impl(FlashUmlRelationship.TYPE_ONE_TO_MANY, DiagramLineType.SOLID, label, "1", "*", 1, DiagramRelationships.getAngleArrow(), DiagramRelationshipInfo.DIAMOND, element, true);
        }

        private static class Impl
        extends DiagramRelationshipInfoAdapter
        implements FlashUmlRelationship {
            private final String myType;
            private final Shape myStartArrow;
            private final Shape myEndArrow;
            private final boolean myAllowMultipleLinks;
            @Nullable
            private SmartPsiElementPointer<PsiElement> myElementPointer;

            public Impl(@NotNull String type, DiagramLineType lineType, @Nullable String label, @Nullable String fromLabel, @Nullable String toLabel, int width, Shape startArrow, Shape endArrow, @Nullable PsiElement element, boolean allowMultipleLinks) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/uml/FlashUmlRelationship$Factory$Impl", "<init>"));
                }
                super(type, lineType, label, fromLabel, toLabel, width);
                this.myType = type;
                this.myStartArrow = startArrow;
                this.myEndArrow = endArrow;
                this.myAllowMultipleLinks = allowMultipleLinks;
                this.myElementPointer = element != null ? SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element) : null;
            }

            @Override
            @Nullable
            public PsiElement getElement() {
                return this.myElementPointer != null ? this.myElementPointer.getElement() : null;
            }

            @Override
            @NotNull
            public String getType() {
                String string = this.myType;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/uml/FlashUmlRelationship$Factory$Impl", "getType"));
                }
                return string;
            }

            public Shape getStartArrow() {
                return this.myStartArrow;
            }

            public Shape getEndArrow() {
                return this.myEndArrow;
            }

            public boolean equals(Object o) {
                PsiElement element;
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Impl impl = (Impl)o;
                if (this.myType != null ? !this.myType.equals(impl.myType) : impl.myType != null) {
                    return false;
                }
                if (this.myAllowMultipleLinks != impl.myAllowMultipleLinks) {
                    return false;
                }
                return !this.myAllowMultipleLinks || !((element = this.getElement()) != null ? !element.equals(impl.getElement()) : impl.getElement() != null);
            }

            public int hashCode() {
                int result = this.myType != null ? this.myType.hashCode() : 0;
                result = 31 * result + (this.myAllowMultipleLinks ? 1 : 0);
                if (this.myAllowMultipleLinks) {
                    PsiElement element = this.getElement();
                    result = 31 * result + (element != null ? element.hashCode() : 0);
                }
                return result;
            }
        }
    }
}

