/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.GitResetDialog;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitResetHead
extends GitRepositoryAction {
    @Override
    @NotNull
    protected String getActionName() {
        String string = GitBundle.getString("reset.action.name");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/actions/GitResetHead", "getActionName"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void perform(@NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/GitResetHead", "perform"));
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRoots", "git4idea/actions/GitResetHead", "perform"));
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultRoot", "git4idea/actions/GitResetHead", "perform"));
        }
        GitResetDialog d = new GitResetDialog(project, gitRoots, defaultRoot);
        if (!d.showAndGet()) {
            return;
        }
        GitLineHandler h = d.handler();
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)project);
        try {
            GitHandlerUtil.doSynchronously(h, GitBundle.getString("resetting.title"), h.printableCommandLine());
        }
        finally {
            token.finish();
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        manager.updateRepository(d.getGitRoot());
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{d.getGitRoot()});
        if (!h.errors().isEmpty()) {
            GitResetHead.showErrors(project, this.getActionName(), h.errors());
        }
    }
}

