/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsBranchPopup;
import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.RootAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitBranchPopupActions;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitBranchPopup
extends DvcsBranchPopup<GitRepository> {
    private static final String DIMENSION_SERVICE_KEY = "Git.Branch.Popup";
    static final String SHOW_ALL_LOCALS_KEY = "Git.Branch.Popup.ShowAllLocals";
    static final String SHOW_ALL_REMOTES_KEY = "Git.Branch.Popup.ShowAllRemotes";
    static final String SHOW_ALL_REPOSITORIES = "Git.Branch.Popup.ShowAllRepositories";

    static GitBranchPopup getInstance(@NotNull Project project, @NotNull GitRepository currentRepository) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/ui/branch/GitBranchPopup", "getInstance"));
        }
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "git4idea/ui/branch/GitBranchPopup", "getInstance"));
        }
        GitVcsSettings vcsSettings = GitVcsSettings.getInstance(project);
        Condition preselectActionCondition = action -> {
            if (action instanceof GitBranchPopupActions.LocalBranchActions) {
                GitBranchPopupActions.LocalBranchActions branchAction = (GitBranchPopupActions.LocalBranchActions)((Object)action);
                String branchName = branchAction.getBranchName();
                List<GitRepository> repositories = branchAction.getRepositories();
                String recentBranch = repositories.size() == 1 ? vcsSettings.getRecentBranchesByRepository().get(repositories.iterator().next().getRoot().getPath()) : vcsSettings.getRecentCommonBranch();
                if (recentBranch != null && recentBranch.equals(branchName)) {
                    return true;
                }
            }
            return false;
        };
        return new GitBranchPopup(currentRepository, GitUtil.getRepositoryManager(project), vcsSettings, (Condition<AnAction>)preselectActionCondition);
    }

    private GitBranchPopup(@NotNull GitRepository currentRepository, @NotNull GitRepositoryManager repositoryManager, @NotNull GitVcsSettings vcsSettings, @NotNull Condition<AnAction> preselectActionCondition) {
        if (currentRepository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRepository", "git4idea/ui/branch/GitBranchPopup", "<init>"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/ui/branch/GitBranchPopup", "<init>"));
        }
        if (vcsSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsSettings", "git4idea/ui/branch/GitBranchPopup", "<init>"));
        }
        if (preselectActionCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preselectActionCondition", "git4idea/ui/branch/GitBranchPopup", "<init>"));
        }
        super((Repository)currentRepository, (AbstractRepositoryManager)repositoryManager, (DvcsMultiRootBranchConfig)new GitMultiRootBranchConfig(repositoryManager.getRepositories()), (DvcsSyncSettings)vcsSettings, preselectActionCondition, DIMENSION_SERVICE_KEY);
    }

    protected void setCurrentBranchInfo() {
        String currentBranchText = "Current branch";
        currentBranchText = this.myRepositoryManager.moreThanOneRoot() ? (this.myMultiRootBranchConfig.diverged() ? currentBranchText + " in " + DvcsUtil.getShortRepositoryName((Repository)this.myCurrentRepository) + ": " + GitBranchUtil.getDisplayableBranchText((GitRepository)this.myCurrentRepository) : currentBranchText + ": " + this.myMultiRootBranchConfig.getCurrentBranch()) : currentBranchText + ": " + GitBranchUtil.getDisplayableBranchText((GitRepository)this.myCurrentRepository);
        this.myPopup.setAdText(currentBranchText, 0);
    }

    protected void fillWithCommonRepositoryActions(@NotNull DefaultActionGroup popupGroup, @NotNull AbstractRepositoryManager<GitRepository> repositoryManager) {
        if (popupGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupGroup", "git4idea/ui/branch/GitBranchPopup", "fillWithCommonRepositoryActions"));
        }
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/ui/branch/GitBranchPopup", "fillWithCommonRepositoryActions"));
        }
        List allRepositories = repositoryManager.getRepositories();
        popupGroup.add((AnAction)new GitBranchPopupActions.GitNewBranchAction(this.myProject, allRepositories));
        popupGroup.add((AnAction)new GitBranchPopupActions.CheckoutRevisionActions(this.myProject, allRepositories));
        popupGroup.addAll((ActionGroup)this.createRepositoriesActions());
        popupGroup.addSeparator("Common Local Branches");
        List localBranchActions = this.myMultiRootBranchConfig.getLocalBranchNames().stream().map(l -> this.createLocalBranchActions(allRepositories, (String)l)).filter(Objects::nonNull).collect(Collectors.toList());
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (DefaultActionGroup)popupGroup, (List)ContainerUtil.sorted(localBranchActions, (Comparator)BranchActionUtil.FAVORITE_BRANCH_COMPARATOR), (int)BranchActionUtil.getNumOfTopShownBranches(localBranchActions), (String)SHOW_ALL_LOCALS_KEY, (boolean)true);
        popupGroup.addSeparator("Common Remote Branches");
        List remoteBranchActions = ContainerUtil.map(((GitMultiRootBranchConfig)this.myMultiRootBranchConfig).getRemoteBranches(), remoteBranch -> new GitBranchPopupActions.RemoteBranchActions(this.myProject, allRepositories, (String)remoteBranch, (GitRepository)this.myCurrentRepository));
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (DefaultActionGroup)popupGroup, (List)ContainerUtil.sorted((Collection)remoteBranchActions, (Comparator)BranchActionUtil.FAVORITE_BRANCH_COMPARATOR), (int)BranchActionUtil.getNumOfFavorites((List)remoteBranchActions), (String)SHOW_ALL_REMOTES_KEY);
    }

    @Nullable
    private GitBranchPopupActions.LocalBranchActions createLocalBranchActions(@NotNull List<GitRepository> allRepositories, @NotNull String branch) {
        if (allRepositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allRepositories", "git4idea/ui/branch/GitBranchPopup", "createLocalBranchActions"));
        }
        if (branch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branch", "git4idea/ui/branch/GitBranchPopup", "createLocalBranchActions"));
        }
        List repositories = this.filterRepositoriesNotOnThisBranch(branch, allRepositories);
        return repositories.isEmpty() ? null : new GitBranchPopupActions.LocalBranchActions(this.myProject, repositories, branch, (GitRepository)this.myCurrentRepository);
    }

    @NotNull
    protected DefaultActionGroup createRepositoriesActions() {
        DefaultActionGroup popupGroup = new DefaultActionGroup(null, false);
        popupGroup.addSeparator("Repositories");
        List rootActions = DvcsUtil.sortRepositories((Collection)this.myRepositoryManager.getRepositories()).stream().map(repo -> new RootAction((Repository)repo, (Repository)(this.highlightCurrentRepo() ? (GitRepository)this.myCurrentRepository : null), new GitBranchPopupActions(repo.getProject(), (GitRepository)repo).createActions(), GitBranchUtil.getDisplayableBranchText(repo))).collect(Collectors.toList());
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (DefaultActionGroup)popupGroup, rootActions, (int)(rootActions.size() > 8 ? 5 : 8), (String)SHOW_ALL_REPOSITORIES);
        DefaultActionGroup defaultActionGroup = popupGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/ui/branch/GitBranchPopup", "createRepositoriesActions"));
        }
        return defaultActionGroup;
    }

    protected void fillPopupWithCurrentRepositoryActions(@NotNull DefaultActionGroup popupGroup, @Nullable DefaultActionGroup actions) {
        if (popupGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupGroup", "git4idea/ui/branch/GitBranchPopup", "fillPopupWithCurrentRepositoryActions"));
        }
        popupGroup.addAll(new GitBranchPopupActions(((GitRepository)this.myCurrentRepository).getProject(), (GitRepository)this.myCurrentRepository).createActions(actions, this.myRepoTitleInfo, true));
    }
}

